/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class HeapTrackingLongHashSet
extends LongHashSet
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongHashSet.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongHashSet.arrayHeapSize(16));
        return new HeapTrackingLongHashSet(memoryTracker, 16);
    }

    private HeapTrackingLongHashSet(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingLongHashSet.arrayHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingLongHashSet.arrayHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingLongHashSet.arrayHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    private static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + arrayLength * 8));
    }
}

