/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.helpers.collection.WrappingResourceIterator;

public abstract class IteratorUtil {
    public static final Function<Enum, String> ENUM_NAME = Enum::name;
    private static final ResourceIterator EMPTY_ITERATOR = new ResourceIterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    };

    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T first(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.firstOrNull(iterator));
    }

    public static <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T last(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        return IteratorUtil.single(iterator, null);
    }

    public static <T> T single(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.singleOrNull(iterator));
    }

    public static <T> T fromEnd(Iterator<T> iterator, int n) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.fromEndOrNull(iterator, n));
    }

    public static <T> T fromEndOrNull(Iterator<T> iterator, int n) {
        ArrayDeque<T> trail = new ArrayDeque<T>(n);
        while (iterator.hasNext()) {
            if (trail.size() > n) {
                trail.removeLast();
            }
            trail.addFirst(iterator.next());
        }
        return trail.size() == n + 1 ? (T)trail.getLast() : null;
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other) {
        while (first.hasNext() && other.hasNext()) {
            if (first.next().equals(other.next())) continue;
            return false;
        }
        return first.hasNext() == other.hasNext();
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return IteratorUtil.firstOrNull(iterable.iterator());
    }

    public static <T> T first(Iterable<T> iterable) {
        return IteratorUtil.first(iterable.iterator());
    }

    public static <T> T lastOrNull(Iterable<T> iterable) {
        return IteratorUtil.lastOrNull(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return IteratorUtil.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return IteratorUtil.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return IteratorUtil.single(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable, T itemIfNone) {
        return IteratorUtil.single(iterable.iterator(), itemIfNone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T single(Iterator<T> iterator, T itemIfNone) {
        try {
            T result;
            T t = result = iterator.hasNext() ? iterator.next() : itemIfNone;
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
            }
            T t2 = result;
            return t2;
        }
        finally {
            if (iterator instanceof Resource) {
                ((Resource)iterator).close();
            }
        }
    }

    public static <T> T fromEnd(Iterable<T> iterable, int n) {
        return IteratorUtil.fromEnd(iterable.iterator(), n);
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            IteratorUtil.addUnique(collection, iterator.next());
        }
        return collection;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollection(iterable.iterator(), collection);
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollectionUnique(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return IteratorUtil.loop(iterator);
    }

    public static <T> int count(Iterator<T> iterator) {
        return IteratorUtil.count(iterator, Predicates.alwaysTrue());
    }

    public static <T> int count(Iterator<T> iterator, Predicate<T> filter) {
        int result = 0;
        while (iterator.hasNext()) {
            if (!filter.test(iterator.next())) continue;
            ++result;
        }
        return result;
    }

    public static <T> int count(Iterable<T> iterable) {
        return IteratorUtil.count(iterable, Predicates.alwaysTrue());
    }

    public static <T> int count(Iterable<T> iterable, Predicate<T> filter) {
        return IteratorUtil.count(iterable.iterator(), filter);
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new ArrayList());
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new ArrayList());
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new ArrayList());
    }

    public static <T> List<T> asList(Iterable<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new ArrayList());
    }

    public static <T, EX extends Exception> List<T> asList(RawIterator<T, EX> iterator) throws EX {
        ArrayList<T> out = new ArrayList<T>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static <T, U> Map<T, U> asMap(Iterable<Pair<T, U>> pairs) {
        HashMap<T, U> map = new HashMap<T, U>();
        for (Pair<T, U> pair : pairs) {
            map.put(pair.first(), pair.other());
        }
        return map;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new HashSet());
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new HashSet());
    }

    public static <T> Set<T> asUniqueSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollectionUnique(iterable, new HashSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> emptySetOf(Class<T> type) {
        return Collections.emptySet();
    }

    public static <T> List<T> emptyListOf(Class<T> type) {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return IteratorUtil.asSet(items);
    }

    @SafeVarargs
    public static <T> Set<T> asUniqueSet(T ... items) {
        HashSet set = new HashSet();
        for (T item : items) {
            IteratorUtil.addUnique(set, item);
        }
        return set;
    }

    public static <T> Set<T> asUniqueSet(Iterator<T> items) {
        HashSet set = new HashSet();
        while (items.hasNext()) {
            IteratorUtil.addUnique(set, items.next());
        }
        return set;
    }

    public static Set<String> asEnumNameSet(Iterable<Enum> enums) {
        return IteratorUtil.asSet(Iterables.map(ENUM_NAME, enums));
    }

    public static <E extends Enum<E>> Set<String> asEnumNameSet(Class<E> clazz) {
        return IteratorUtil.asSet(Iterables.map(ENUM_NAME, EnumSet.allOf(clazz)));
    }

    public static Iterable<Long> asIterable(long ... array) {
        return () -> IteratorUtil.asIterator(array);
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(T ... array) {
        return () -> IteratorUtil.iterator(array);
    }

    public static Iterator<Long> asIterator(final long ... array) {
        return new PrefetchingIterator<Long>(){
            private int index;

            @Override
            protected Long fetchNextOrNull() {
                try {
                    Long l = this.index < array.length ? Long.valueOf(array[this.index]) : null;
                    return l;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> asIterator(final int maxItems, final T ... array) {
        return new PrefetchingIterator<T>(){
            private int index;

            @Override
            protected T fetchNextOrNull() {
                try {
                    Object object = this.index < array.length && this.index < maxItems ? array[this.index] : null;
                    return object;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T> Iterator<T> iterator(final T item) {
        if (item == null) {
            return IteratorUtil.emptyIterator();
        }
        return new Iterator<T>(){
            T myItem;
            {
                this.myItem = item;
            }

            @Override
            public boolean hasNext() {
                return this.myItem != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object toReturn = this.myItem;
                this.myItem = null;
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... items) {
        return IteratorUtil.asIterator(items.length, items);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(int maxItems, T ... items) {
        return IteratorUtil.asIterator(maxItems, items);
    }

    public static <T> ResourceIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean contains(Iterator<T> iterator, T item) {
        try {
            for (T element : IteratorUtil.loop(iterator)) {
                if (!(item == null ? element == null : item.equals(element))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)iterator).close();
            }
        }
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterator<T> iterator) {
        if (iterator instanceof ResourceIterator) {
            return (ResourceIterator)iterator;
        }
        return new WrappingResourceIterator<T>(iterator);
    }

    public static <T> ResourceIterator<T> resourceIterator(final Iterator<T> iterator, final Resource resource) {
        return new PrefetchingResourceIterator<T>(){

            public void close() {
                resource.close();
            }

            @Override
            protected T fetchNextOrNull() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    public static <T> ResourceIterable<T> resourceIterable(Iterable<T> iterable) {
        return () -> IteratorUtil.resourceIterator(iterable.iterator(), Resource.EMPTY);
    }

    @SafeVarargs
    public static <T> T[] array(T ... items) {
        return items;
    }
}

