/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.NoSuchElementException;

public interface RawIterator<T, EXCEPTION extends Exception> {
    public boolean hasNext() throws EXCEPTION;

    public T next() throws EXCEPTION;

    default public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T, EX extends Exception> RawIterator<T, EX> of(final T ... values) {
        return new RawIterator<T, EX>(){
            private int position = 0;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < values.length;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return values[this.position++];
            }
        };
    }
}

