/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.block.factory.primitive.LongPredicates;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.utility.internal.primitive.LongIteratorIterate;

public abstract class LongIterableAdapter
extends AbstractLongIterable {
    public long[] toArray() {
        long[] array = new long[this.size()];
        LongIterator itr = this.longIterator();
        int index = 0;
        while (itr.hasNext()) {
            array[index++] = itr.next();
        }
        return array;
    }

    public boolean contains(long value) {
        return this.anySatisfy(LongPredicates.equal((long)value));
    }

    public void each(LongProcedure procedure) {
        LongIteratorIterate.forEach((LongIterator)this.longIterator(), (LongProcedure)procedure);
    }

    public LongIterable select(LongPredicate predicate) {
        return this.select(predicate, (MutableLongCollection)LongLists.mutable.empty());
    }

    public LongIterable reject(LongPredicate predicate) {
        return this.reject(predicate, (MutableLongCollection)LongLists.mutable.empty());
    }

    public <V> RichIterable<V> collect(LongToObjectFunction<? extends V> function) {
        return (RichIterable)this.collect(function, (Collection)Lists.mutable.empty());
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return LongIteratorIterate.detectIfNone((LongIterator)this.longIterator(), (LongPredicate)predicate, (long)ifNone);
    }

    public int count(LongPredicate predicate) {
        return LongIteratorIterate.count((LongIterator)this.longIterator(), (LongPredicate)predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return LongIteratorIterate.anySatisfy((LongIterator)this.longIterator(), (LongPredicate)predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return LongIteratorIterate.allSatisfy((LongIterator)this.longIterator(), (LongPredicate)predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)LongIteratorIterate.injectInto((LongIterator)this.longIterator(), injectedValue, function);
    }

    public long sum() {
        return LongIteratorIterate.sum((LongIterator)this.longIterator());
    }

    public long max() {
        return LongIteratorIterate.max((LongIterator)this.longIterator());
    }

    public long min() {
        return LongIteratorIterate.min((LongIterator)this.longIterator());
    }

    public int size() {
        return this.count(LongPredicates.alwaysTrue());
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            LongIterator itr = this.longIterator();
            boolean first = true;
            while (itr.hasNext()) {
                if (!first) {
                    appendable.append(separator);
                }
                first = false;
                appendable.append(Long.toString(itr.next()));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

