/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.collection.trackable.AbstractHeapTrackingConcurrentHash;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

abstract class HeapTrackingConcurrentHashCollection<E>
extends AbstractHeapTrackingConcurrentHash
implements AutoCloseable {
    private static final long SHALLOW_SIZE_THIS = HeapEstimator.shallowSizeOfInstance(HeapTrackingConcurrentHashCollection.class);
    static final long SHALLOW_SIZE_WRAPPER = HeapEstimator.shallowSizeOfInstance(Node.class);

    HeapTrackingConcurrentHashCollection(MemoryTracker memoryTracker, int initialCapacity) {
        super(memoryTracker, initialCapacity);
    }

    @Override
    public final long sizeOfWrapperObject() {
        return SHALLOW_SIZE_WRAPPER;
    }

    @Override
    final void transfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        int j = 0;
        while (j < src.length() - 1) {
            Object o = src.get(j);
            if (o == null) {
                if (!src.compareAndSet(j, null, RESIZED)) continue;
                ++j;
                continue;
            }
            if (o == RESIZED || o == RESIZING) {
                j = (j & -AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT) + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
                if (resizeContainer.resizers.get() != 1) continue;
                break;
            }
            if (!src.compareAndSet(j, o, RESIZING)) continue;
            for (Object e = (Node)o; e != null; e = ((Node)e).getNext()) {
                this.unconditionalCopy(dest, (Node<E>)e);
            }
            src.set(j, RESIZED);
            ++j;
        }
        resizeContainer.decrementResizerAndNotify();
        resizeContainer.waitForAllResizers();
    }

    @Override
    final void reverseTransfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        while (resizeContainer.getQueuePosition() > 0) {
            int start = resizeContainer.subtractAndGetQueuePosition();
            int end = start + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
            if (end <= 0) continue;
            if (start < 0) {
                start = 0;
            }
            int j = end - 1;
            while (j >= start) {
                Object o = src.get(j);
                if (o == null) {
                    if (!src.compareAndSet(j, null, RESIZED)) continue;
                    --j;
                    continue;
                }
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer.zeroOutQueuePosition();
                    return;
                }
                if (!src.compareAndSet(j, o, RESIZING)) continue;
                for (Object e = (Node)o; e != null; e = ((Node)e).getNext()) {
                    this.unconditionalCopy(dest, (Node<E>)e);
                }
                src.set(j, RESIZED);
                --j;
            }
        }
    }

    private void unconditionalCopy(AtomicReferenceArray<Object> dest, Node<E> toCopyNode) {
        int hash = this.hash(toCopyNode.value);
        AtomicReferenceArray<Object> currentArray = dest;
        while (true) {
            int length;
            int index;
            Object o;
            if ((o = currentArray.get(index = HeapTrackingConcurrentHashCollection.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = ((AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get((int)(length - 1))).nextArray;
                continue;
            }
            Node<Object> newNode = o == null ? (toCopyNode.getNext() == null ? toCopyNode : new Node(toCopyNode.value)) : new Node(toCopyNode.value, (Node)o);
            if (currentArray.compareAndSet(index, o, newNode)) break;
        }
    }

    @Override
    public final void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE_THIS);
        this.releaseHeap();
    }

    public final Iterator<E> iterator() {
        return new HashSetIterator(this);
    }

    static final class Node<T>
    implements AbstractHeapTrackingConcurrentHash.Wrapper<Node<T>> {
        final T value;
        final Node<T> next;

        Node(T value) {
            this.value = value;
            this.next = null;
        }

        Node(T value, Node<T> next) {
            this.value = value;
            this.next = next;
        }

        @Override
        public Node<T> getNext() {
            return this.next;
        }
    }

    private final class HashSetIterator<T>
    extends AbstractHeapTrackingConcurrentHash.HashIterator<Node<T>>
    implements Iterator<T> {
        private HashSetIterator(HeapTrackingConcurrentHashCollection heapTrackingConcurrentHashCollection) {
            super(heapTrackingConcurrentHashCollection);
        }

        @Override
        public T next() {
            Node e = (Node)this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.getNext();
            if (this.next == null) {
                this.findNext();
            }
            return e.value;
        }
    }
}

