/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceUtils;

public class PrimitiveLongResourceCollections {
    private static final PrimitiveLongResourceIterator EMPTY = new AbstractPrimitiveLongBaseResourceIterator(null){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    public static PrimitiveLongResourceIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveLongResourceIterator iterator(Resource resource, long ... items) {
        return PrimitiveLongCollections.resourceIterator(PrimitiveLongCollections.iterator(items), resource);
    }

    public static long count(PrimitiveLongResourceIterator iterator) throws IOException {
        long count = 0L;
        try (PrimitiveLongResourceIterator primitiveLongResourceIterator = iterator;){
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        return count;
    }

    public static PrimitiveLongResourceIterator concat(PrimitiveLongResourceIterator ... primitiveLongResourceIterators) {
        return PrimitiveLongResourceCollections.concat(Arrays.asList(primitiveLongResourceIterators));
    }

    public static PrimitiveLongResourceIterator concat(Iterable<PrimitiveLongResourceIterator> primitiveLongResourceIterators) {
        return new PrimitiveLongConcatenatingResourceIterator(primitiveLongResourceIterators);
    }

    public static PrimitiveLongResourceIterator complement(final PrimitiveLongResourceIterator original, final long max) {
        return new AbstractPrimitiveLongBaseResourceIterator(original){
            private long current;
            private boolean originalHasNext;
            private long originalNext;

            private void ensureOriginalAtLeast(long minNeeded) {
                while (true) {
                    if (!this.originalHasNext) {
                        if (!original.hasNext()) {
                            return;
                        }
                        this.originalNext = original.next();
                        this.originalHasNext = true;
                    }
                    if (this.originalNext >= minNeeded) {
                        return;
                    }
                    this.originalHasNext = false;
                }
            }

            @Override
            protected boolean fetchNext() {
                while (this.current < max) {
                    this.ensureOriginalAtLeast(this.current);
                    if (this.originalHasNext && this.originalNext == this.current) {
                        ++this.current;
                        this.originalHasNext = false;
                        continue;
                    }
                    return this.next(this.current++);
                }
                return false;
            }
        };
    }

    public static long[] asArray(PrimitiveLongResourceIterator iterator) throws IOException {
        try (PrimitiveLongResourceIterator primitiveLongResourceIterator = iterator;){
            long[] lArray = PrimitiveLongCollections.asArray(iterator);
            return lArray;
        }
    }

    private static final class PrimitiveLongConcatenatingResourceIterator
    extends PrimitiveLongCollections.PrimitiveLongConcatenatingIterator
    implements PrimitiveLongResourceIterator {
        private final Iterable<PrimitiveLongResourceIterator> iterators;
        private volatile boolean closed;

        private PrimitiveLongConcatenatingResourceIterator(Iterable<PrimitiveLongResourceIterator> iterators) {
            super(iterators.iterator());
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            return !this.closed && super.fetchNext();
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                ResourceUtils.closeAll(this.iterators);
            }
        }
    }

    public static abstract class AbstractPrimitiveLongBaseResourceIterator
    extends PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator
    implements PrimitiveLongResourceIterator {
        private Resource resource;

        public AbstractPrimitiveLongBaseResourceIterator(Resource resource) {
            this.resource = resource;
        }

        public void close() {
            if (this.resource != null) {
                this.resource.close();
                this.resource = null;
            }
        }
    }
}

