/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class HeapTrackingSkipList<T>
implements Iterable<T>,
AutoCloseable {
    private static final int MAX_LEVEL = 32;
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingSkipList.class) + HeapEstimator.shallowSizeOfInstance(Random.class);
    private final MemoryTracker memoryTracker;
    private final Comparator<T> comparator;
    private final Node<T> head;
    private final Random random = new Random();
    private int levels = 1;

    private Node<T>[] nodeArray(int size) {
        return Node.array(size);
    }

    public HeapTrackingSkipList(MemoryTracker memoryTracker, Comparator<T> comparator) {
        this.memoryTracker = memoryTracker.getScopedMemoryTracker();
        this.comparator = comparator;
        this.head = new Node<Object>(null, 33);
        this.memoryTracker.allocateHeap(SHALLOW_SIZE + this.head.estimatedHeapUsage());
    }

    protected int getLevel(T value) {
        int level = 0;
        int r = this.random.nextInt();
        while ((r & 1) == 1) {
            if (++level == this.levels) {
                ++this.levels;
                break;
            }
            r >>= 1;
        }
        return level;
    }

    public boolean insert(T value) {
        int level = this.getLevel(value);
        Node<T> current = this.head;
        Node<T>[] prevStack = this.nodeArray(level + 1);
        for (int i = this.levels - 1; i >= 0; --i) {
            int cmp;
            while (current.next[i] != null && (cmp = this.comparator.compare(current.next[i].value, value)) <= 0) {
                if (cmp == 0) {
                    return false;
                }
                current = current.next[i];
            }
            if (i > level) continue;
            prevStack[i] = current;
        }
        Node<T> newNode = new Node<T>(value, level + 1);
        this.memoryTracker.allocateHeap(newNode.estimatedHeapUsage());
        for (int i = 0; i <= level; ++i) {
            newNode.next[i] = prevStack[i].next[i];
            prevStack[i].next[i] = newNode;
        }
        return true;
    }

    public T pop() {
        Node popped = this.head.next[0];
        if (popped == null) {
            return null;
        }
        for (int i = this.levels - 1; i >= 0; --i) {
            if (this.head.next[i] != popped) continue;
            this.head.next[i] = popped.next[i];
            assert (this.head.next[i] != null || this.head.next[i + 1] == null);
        }
        this.memoryTracker.releaseHeap(popped.estimatedHeapUsage());
        return popped.value;
    }

    public T peek() {
        Node node = this.head.next[0];
        if (node == null) {
            return null;
        }
        return node.value;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Node<T> current;
            {
                this.current = HeapTrackingSkipList.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current.next[0] != null;
            }

            @Override
            public T next() {
                this.current = this.current.next[0];
                return this.current.value;
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (T n : this) {
            sb.append(n).append(',');
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.head.next[0] == null;
    }

    @Override
    public void close() {
        Arrays.fill(this.head.next, null);
        this.memoryTracker.close();
    }

    private static class Node<T>
    implements Measurable {
        public final T value;
        public final Node<T>[] next;
        public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Node.class);

        Node(T value, int size) {
            this(value, Node.array(size));
        }

        Node(T value, Node<T>[] next) {
            this.value = value;
            this.next = next;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.value != null) {
                s.append(this.value);
            }
            s.append('[');
            for (int i = 0; i < this.next.length; ++i) {
                s.append(i).append(':');
                if (this.next[i] != null) {
                    s.append(this.next[i].value);
                } else {
                    s.append("null");
                }
                s.append(' ');
            }
            s.append(']');
            return s.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + HeapEstimator.shallowSizeOf((Object[])this.next);
        }

        public static <T> Node<T>[] array(int size) {
            return (Node[])Array.newInstance(Node.class, size);
        }
    }
}

