/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassWriter;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.bytecode.ByteCodeChecker;
import org.neo4j.codegen.bytecode.ByteCodeClassWriter;
import org.neo4j.codegen.bytecode.Configuration;

class ByteCodeGenerator
extends CodeGenerator {
    private final Configuration configuration;
    private final Map<TypeReference, ByteCodeClassWriter> classes = new HashMap<TypeReference, ByteCodeClassWriter>();

    ByteCodeGenerator(ClassLoader parentClassLoader, Configuration configuration) {
        super(parentClassLoader);
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClassWriter generate(TypeReference type, TypeReference base, TypeReference ... interfaces) {
        ByteCodeClassWriter codeWriter = new ByteCodeClassWriter(type, base, interfaces);
        ByteCodeGenerator byteCodeGenerator = this;
        synchronized (byteCodeGenerator) {
            ByteCodeClassWriter old = this.classes.put(type, codeWriter);
            if (old != null) {
                this.classes.put(type, old);
                throw new IllegalStateException("Trying to generate class twice: " + String.valueOf(type));
            }
        }
        return codeWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<? extends ByteCodes> compile(ClassLoader classpathLoader) throws CompilationFailureException {
        ArrayList<ByteCodes> byteCodes;
        ByteCodeGenerator byteCodeGenerator = this;
        synchronized (byteCodeGenerator) {
            byteCodes = new ArrayList<ByteCodes>(this.classes.size());
            for (ByteCodeClassWriter writer : this.classes.values()) {
                byteCodes.add(writer.toByteCodes());
            }
            ByteCodeChecker checker = this.configuration.bytecodeChecker();
            if (checker != null) {
                checker.check(classpathLoader, byteCodes);
            }
            this.classes.clear();
        }
        return byteCodes;
    }
}

