/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.asm.Label;
import org.neo4j.codegen.asm.MethodVisitor;

class JumpVisitor
implements ExpressionVisitor {
    private final ExpressionVisitor eval;
    private final MethodVisitor methodVisitor;
    private final Label target;

    JumpVisitor(ExpressionVisitor eval, MethodVisitor methodVisitor, Label target) {
        this.eval = eval;
        this.methodVisitor = methodVisitor;
        this.target = target;
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments) {
        this.eval.invoke(target, method, arguments);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments) {
        this.eval.invoke(method, arguments);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void load(LocalVariable variable) {
        this.eval.load(variable);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void arrayLoad(Expression array, Expression index) {
        this.eval.arrayLoad(array, index);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void arraySet(Expression array, Expression index, Expression value) {
        this.eval.arraySet(array, index, value);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void arrayLength(Expression array) {
        this.eval.arrayLength(array);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void getField(Expression target, FieldReference field) {
        this.eval.getField(target, field);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void constant(Object value) {
        this.eval.constant(value);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void getStatic(FieldReference field) {
        this.eval.getStatic(field);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void not(Expression expression) {
        expression.accept(this.eval);
        this.methodVisitor.visitJumpInsn(154, this.target);
    }

    @Override
    public void ternary(Expression test, Expression onTrue, Expression onFalse) {
        this.eval.ternary(test, onTrue, onFalse);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void equal(Expression lhs, Expression rhs) {
        this.eval.equal(lhs, rhs);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void notEqual(Expression lhs, Expression rhs) {
        this.eval.equal(lhs, rhs);
        this.methodVisitor.visitJumpInsn(154, this.target);
    }

    @Override
    public void isNull(Expression expression) {
        expression.accept(this.eval);
        this.methodVisitor.visitJumpInsn(199, this.target);
    }

    @Override
    public void notNull(Expression expression) {
        expression.accept(this.eval);
        this.methodVisitor.visitJumpInsn(198, this.target);
    }

    @Override
    public void or(Expression ... expressions) {
        this.eval.or(expressions);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void and(Expression ... expressions) {
        for (Expression expression : expressions) {
            expression.accept(this);
        }
    }

    @Override
    public void gt(Expression lhs, Expression rhs) {
        this.eval.gt(lhs, rhs);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void gte(Expression lhs, Expression rhs) {
        this.eval.gte(lhs, rhs);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void lt(Expression lhs, Expression rhs) {
        this.eval.lt(lhs, rhs);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void lte(Expression lhs, Expression rhs) {
        this.eval.lte(lhs, rhs);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void unbox(Expression expression) {
        this.eval.unbox(expression);
        this.methodVisitor.visitJumpInsn(153, this.target);
    }

    @Override
    public void loadThis(String sourceName) {
        throw new IllegalArgumentException("'" + sourceName + "' is not a boolean expression");
    }

    @Override
    public void newInstance(TypeReference type) {
        throw new IllegalArgumentException("'new' is not a boolean expression");
    }

    @Override
    public void add(Expression lhs, Expression rhs) {
        throw new IllegalArgumentException("'+' is not a boolean expression");
    }

    @Override
    public void subtract(Expression lhs, Expression rhs) {
        throw new IllegalArgumentException("'-' is not a boolean expression");
    }

    @Override
    public void multiply(Expression lhs, Expression rhs) {
        throw new IllegalArgumentException("'*' is not a boolean expression");
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        throw new IllegalArgumentException("cast is not a boolean expression");
    }

    @Override
    public void instanceOf(TypeReference type, Expression expression) {
        throw new IllegalArgumentException("cast is not a boolean expression");
    }

    @Override
    public void newInitializedArray(TypeReference type, Expression ... constants) {
        throw new IllegalArgumentException("'new' (array) is not a boolean expression");
    }

    @Override
    public void newArray(TypeReference type, int size) {
        throw new IllegalArgumentException("'new' (array) is not a boolean expression");
    }

    @Override
    public void longToDouble(Expression expression) {
        throw new IllegalArgumentException("cast is not a boolean expression");
    }

    @Override
    public void pop(Expression expression) {
        throw new IllegalArgumentException("pop is not a boolean expression");
    }

    @Override
    public void box(Expression expression) {
        throw new IllegalArgumentException("box is not a boolean expression");
    }
}

