/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.codegen.Binding;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.InvalidState;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.MethodTemplate;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public class ClassGenerator
implements AutoCloseable {
    private final ClassHandle handle;
    private ClassEmitter emitter;
    private Map<String, FieldReference> fields;
    private boolean hasConstructor;

    ClassGenerator(ClassHandle handle, ClassEmitter emitter) {
        this.handle = handle;
        this.emitter = emitter;
    }

    @Override
    public void close() {
        if (!this.hasConstructor) {
            this.generate(MethodTemplate.constructor(new Parameter[0]).invokeSuper().build(), new Binding[0]);
        }
        this.emitter.done();
        this.handle.generator.closeClass();
        this.emitter = InvalidState.CLASS_DONE;
    }

    public ClassHandle handle() {
        return this.handle;
    }

    public FieldReference field(Class<?> type, String name) {
        return this.field(TypeReference.typeReference(type), name);
    }

    public FieldReference field(TypeReference type, String name) {
        return this.emitField(1, type, name, null);
    }

    public FieldReference staticField(Class<?> type, String name, Expression value) {
        return this.staticField(TypeReference.typeReference(type), name, value);
    }

    public FieldReference staticField(TypeReference type, String name) {
        return this.emitField(9, type, name, null);
    }

    public FieldReference staticField(TypeReference type, String name, Expression value) {
        return this.emitField(26, type, name, Objects.requireNonNull(value));
    }

    private FieldReference emitField(int modifiers, TypeReference type, String name, Expression value) {
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldReference>();
        } else if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException(this.handle + " already has a field '" + name + "'");
        }
        FieldReference field = new FieldReference(modifiers, this.handle, type, name);
        this.fields.put(name, field);
        this.emitter.field(field, value);
        return field;
    }

    public MethodReference generate(MethodTemplate template, Binding ... bindings) {
        try (CodeBlock generator = this.generate(template.declaration(this.handle));){
            template.generate(generator);
        }
        return MethodReference.methodReference((TypeReference)this.handle, template.returnType(), template.name(), template.modifiers(), template.parameterTypes());
    }

    public CodeBlock generateConstructor(Parameter ... parameters) {
        return this.generate(MethodDeclaration.constructor(this.handle, parameters, TypeReference.NO_TYPES, 1, MethodDeclaration.TypeParameter.NO_PARAMETERS));
    }

    public CodeBlock generateConstructor(int modifiers, Parameter ... parameters) {
        return this.generate(MethodDeclaration.constructor(this.handle, parameters, TypeReference.NO_TYPES, modifiers, MethodDeclaration.TypeParameter.NO_PARAMETERS));
    }

    public CodeBlock generateMethod(Class<?> returnType, String name, Parameter ... parameters) {
        return this.generateMethod(TypeReference.typeReference(returnType), name, 1, parameters);
    }

    public CodeBlock generateMethod(Class<?> returnType, String name, int modifiers, Parameter ... parameters) {
        return this.generateMethod(TypeReference.typeReference(returnType), name, modifiers, parameters);
    }

    public CodeBlock generateMethod(TypeReference returnType, String name, Parameter ... parameters) {
        return this.generate(MethodDeclaration.method((TypeReference)this.handle, returnType, name, parameters, TypeReference.NO_TYPES, 1, MethodDeclaration.TypeParameter.NO_PARAMETERS));
    }

    public CodeBlock generateMethod(TypeReference returnType, String name, int modifiers, Parameter ... parameters) {
        return this.generate(MethodDeclaration.method((TypeReference)this.handle, returnType, name, parameters, TypeReference.NO_TYPES, modifiers, MethodDeclaration.TypeParameter.NO_PARAMETERS));
    }

    public CodeBlock generate(MethodDeclaration.Builder builder) {
        return this.generate(builder.build(this.handle));
    }

    private CodeBlock generate(MethodDeclaration declaration) {
        if (declaration.isConstructor()) {
            this.hasConstructor = true;
        }
        return new CodeBlock(this, this.emitter.method(declaration), declaration.parameters());
    }

    FieldReference getField(String name) {
        return this.fields == null ? null : this.fields.get(name);
    }
}

