/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.asm.ClassVisitor;
import org.neo4j.codegen.asm.Label;
import org.neo4j.codegen.asm.MethodVisitor;
import org.neo4j.codegen.bytecode.Block;
import org.neo4j.codegen.bytecode.ByteCodeExpressionVisitor;
import org.neo4j.codegen.bytecode.If;
import org.neo4j.codegen.bytecode.JumpVisitor;
import org.neo4j.codegen.bytecode.Method;
import org.neo4j.codegen.bytecode.While;

class MethodByteCodeEmitter
implements MethodEmitter {
    private final MethodVisitor methodVisitor;
    private final MethodDeclaration declaration;
    private final ExpressionVisitor expressionVisitor;
    private Deque<Block> stateStack = new LinkedList<Block>();

    MethodByteCodeEmitter(ClassVisitor classVisitor, MethodDeclaration declaration, TypeReference ignore) {
        this.declaration = declaration;
        for (Parameter parameter : declaration.parameters()) {
            TypeReference type = parameter.type();
            if (!type.isInnerClass() || type.isArray()) continue;
            classVisitor.visitInnerClass(ByteCodeUtils.byteCodeName(type), ByteCodeUtils.outerName(type), type.simpleName(), type.modifiers());
        }
        this.methodVisitor = classVisitor.visitMethod(1, declaration.name(), ByteCodeUtils.desc(declaration), ByteCodeUtils.signature(declaration), ByteCodeUtils.exceptions(declaration));
        this.methodVisitor.visitCode();
        this.expressionVisitor = new ByteCodeExpressionVisitor(this.methodVisitor);
        this.stateStack.push(new Method(this.methodVisitor, declaration.returnType().isVoid()));
    }

    @Override
    public void done() {
        this.methodVisitor.visitEnd();
    }

    @Override
    public void expression(Expression expression) {
        expression.accept(this.expressionVisitor);
    }

    @Override
    public void put(Expression target, FieldReference field, Expression value) {
        target.accept(this.expressionVisitor);
        value.accept(this.expressionVisitor);
        this.methodVisitor.visitFieldInsn(181, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
    }

    @Override
    public void returns() {
        this.methodVisitor.visitInsn(177);
    }

    @Override
    public void returns(Expression value) {
        value.accept(this.expressionVisitor);
        if (this.declaration.returnType().isPrimitive()) {
            switch (this.declaration.returnType().name()) {
                case "int": 
                case "byte": 
                case "short": 
                case "char": 
                case "boolean": {
                    this.methodVisitor.visitInsn(172);
                    break;
                }
                case "long": {
                    this.methodVisitor.visitInsn(173);
                    break;
                }
                case "float": {
                    this.methodVisitor.visitInsn(174);
                    break;
                }
                case "double": {
                    this.methodVisitor.visitInsn(175);
                    break;
                }
                default: {
                    this.methodVisitor.visitInsn(176);
                    break;
                }
            }
        } else {
            this.methodVisitor.visitInsn(176);
        }
    }

    @Override
    public void assign(LocalVariable variable, Expression value) {
        value.accept(this.expressionVisitor);
        if (variable.type().isPrimitive()) {
            switch (variable.type().name()) {
                case "int": 
                case "byte": 
                case "short": 
                case "char": 
                case "boolean": {
                    this.methodVisitor.visitVarInsn(54, variable.index());
                    break;
                }
                case "long": {
                    this.methodVisitor.visitVarInsn(55, variable.index());
                    break;
                }
                case "float": {
                    this.methodVisitor.visitVarInsn(56, variable.index());
                    break;
                }
                case "double": {
                    this.methodVisitor.visitVarInsn(57, variable.index());
                    break;
                }
                default: {
                    this.methodVisitor.visitVarInsn(58, variable.index());
                    break;
                }
            }
        } else {
            this.methodVisitor.visitVarInsn(58, variable.index());
        }
    }

    @Override
    public void beginWhile(Expression test) {
        Label repeat = new Label();
        Label done = new Label();
        this.methodVisitor.visitLabel(repeat);
        test.accept(new JumpVisitor(this.expressionVisitor, this.methodVisitor, done));
        this.stateStack.push(new While(this.methodVisitor, repeat, done));
    }

    @Override
    public void beginIf(Expression test) {
        Label after = new Label();
        test.accept(new JumpVisitor(this.expressionVisitor, this.methodVisitor, after));
        this.stateStack.push(new If(this.methodVisitor, after));
    }

    @Override
    public void beginBlock() {
        this.stateStack.push(() -> {});
    }

    @Override
    public void endBlock() {
        if (this.stateStack.isEmpty()) {
            throw new IllegalStateException("Unbalanced blocks");
        }
        this.stateStack.pop().endBlock();
    }

    @Override
    public <T> void tryCatchBlock(Consumer<T> body, Consumer<T> handler, LocalVariable exception, T block) {
        Label start = new Label();
        Label end = new Label();
        Label handle = new Label();
        Label after = new Label();
        this.methodVisitor.visitTryCatchBlock(start, end, handle, ByteCodeUtils.byteCodeName(exception.type()));
        this.methodVisitor.visitLabel(start);
        body.accept(block);
        this.methodVisitor.visitLabel(end);
        this.methodVisitor.visitJumpInsn(167, after);
        this.methodVisitor.visitLabel(handle);
        this.methodVisitor.visitVarInsn(58, exception.index());
        handler.accept(block);
        this.methodVisitor.visitLabel(after);
    }

    @Override
    public void throwException(Expression exception) {
        exception.accept(this.expressionVisitor);
        this.methodVisitor.visitInsn(191);
    }

    @Override
    public void declare(LocalVariable local) {
    }

    @Override
    public void assignVariableInScope(LocalVariable local, Expression value) {
        this.assign(local, value);
    }
}

