/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.IntFunction;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.bytecode.ByteCodeChecker;
import org.neo4j.codegen.bytecode.BytecodeDiagnostic;
import org.neo4j.codegen.bytecode.Configuration;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.tree.analysis.Value;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

class ByteCodeVerifier
implements ByteCodeChecker,
CodeGeneratorOption {
    ByteCodeVerifier() {
    }

    static CodeGeneratorOption loadVerifier() {
        if (Analyzer.class.getName().isEmpty() || CheckClassAdapter.class.getName().isEmpty()) {
            throw new AssertionError((Object)"This code is here to ensure the optional ASM classes are on the classpath");
        }
        return new ByteCodeVerifier();
    }

    @Override
    public void applyTo(Object target) {
        if (target instanceof Configuration) {
            ((Configuration)target).withBytecodeChecker(this);
        }
    }

    @Override
    public void check(ClassLoader classpathLoader, Collection<ByteCodes> byteCodes) throws CompilationFailureException {
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>(byteCodes.size());
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (ByteCodes byteCode : byteCodes) {
            try {
                classes.add(ByteCodeVerifier.classNode(byteCode.bytes()));
            }
            catch (Exception e) {
                failures.add(new Failure(e, e.toString()));
            }
        }
        if (!failures.isEmpty()) {
            throw ByteCodeVerifier.compilationFailure(failures);
        }
        AssignmentChecker check = new AssignmentChecker(classpathLoader, classes);
        for (ClassNode clazz : classes) {
            ByteCodeVerifier.verify(check, clazz, failures);
        }
        if (!failures.isEmpty()) {
            throw ByteCodeVerifier.compilationFailure(failures);
        }
    }

    private static void verify(AssignmentChecker check, ClassNode clazz, List<Failure> failures) {
        Verifier verifier = new Verifier(clazz, check);
        for (MethodNode method : clazz.methods) {
            Analyzer analyzer = new Analyzer((Interpreter)verifier);
            try {
                analyzer.analyze(clazz.name, method);
            }
            catch (Exception cause) {
                failures.add(new Failure(cause, ByteCodeVerifier.detailedMessage(cause.getMessage(), method, analyzer.getFrames(), cause instanceof AnalyzerException ? ((AnalyzerException)cause).node : null)));
            }
        }
    }

    private static ClassNode classNode(ByteBuffer bytecode) {
        byte[] bytes;
        if (bytecode.hasArray()) {
            bytes = bytecode.array();
        } else {
            bytes = new byte[bytecode.limit()];
            bytecode.get(bytes);
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(bytes).accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)classNode, false), 2);
        return classNode;
    }

    private static CompilationFailureException compilationFailure(List<Failure> failures) {
        ArrayList<BytecodeDiagnostic> diagnostics = new ArrayList<BytecodeDiagnostic>(failures.size());
        for (Failure failure : failures) {
            diagnostics.add(new BytecodeDiagnostic(failure.message));
        }
        CompilationFailureException exception = new CompilationFailureException(diagnostics);
        for (Failure failure : failures) {
            exception.addSuppressed(failure.cause);
        }
        return exception;
    }

    private static String detailedMessage(String errorMessage, MethodNode method, Frame[] frames, AbstractInsnNode errorLocation) {
        StringWriter message = new StringWriter();
        try (PrintWriter out = new PrintWriter(message);){
            ArrayList<Integer> localLengths = new ArrayList<Integer>();
            ArrayList<Integer> stackLengths = new ArrayList<Integer>();
            for (Frame frame : frames) {
                int i;
                if (frame == null) continue;
                for (i = 0; i < frame.getLocals(); ++i) {
                    ByteCodeVerifier.insert(i, frame.getLocal(i), localLengths);
                }
                for (i = 0; i < frame.getStackSize(); ++i) {
                    ByteCodeVerifier.insert(i, frame.getStack(i), stackLengths);
                }
            }
            Textifier formatted = new Textifier();
            TraceMethodVisitor mv = new TraceMethodVisitor((Printer)formatted);
            out.println(errorMessage);
            out.append("\t\tin ").append(method.name).append(method.desc).println();
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode insn = method.instructions.get(i);
                insn.accept((MethodVisitor)mv);
                Frame frame = frames[i];
                out.append("\t\t");
                out.append(insn == errorLocation ? ">>> " : "    ");
                out.format("%05d [", i);
                if (frame == null) {
                    ByteCodeVerifier.padding(out, localLengths.listIterator(), '?');
                    out.append(" : ");
                    ByteCodeVerifier.padding(out, stackLengths.listIterator(), '?');
                } else {
                    ByteCodeVerifier.emit(out, localLengths, arg_0 -> ((Frame)frame).getLocal(arg_0), frame.getLocals());
                    ByteCodeVerifier.padding(out, localLengths.listIterator(frame.getLocals()), '-');
                    out.append(" : ");
                    ByteCodeVerifier.emit(out, stackLengths, arg_0 -> ((Frame)frame).getStack(arg_0), frame.getStackSize());
                    ByteCodeVerifier.padding(out, stackLengths.listIterator(frame.getStackSize()), ' ');
                }
                out.print("] : ");
                out.print(formatted.text.get(formatted.text.size() - 1));
            }
            for (int j = 0; j < method.tryCatchBlocks.size(); ++j) {
                ((TryCatchBlockNode)method.tryCatchBlocks.get(j)).accept((MethodVisitor)mv);
                out.print(" " + formatted.text.get(formatted.text.size() - 1));
            }
        }
        return message.toString();
    }

    private static void emit(PrintWriter out, List<Integer> lengths, IntFunction<Value> valueLookup, int values) {
        for (int i = 0; i < values; ++i) {
            if (i > 0) {
                out.append(' ');
            }
            String name = ByteCodeVerifier.shortName(valueLookup.apply(i).toString());
            int pad = lengths.get(i) - name.length();
            while (pad-- > 0) {
                out.append(' ');
            }
            out.append(name);
        }
    }

    private static void padding(PrintWriter out, ListIterator<Integer> lengths, char var) {
        while (lengths.hasNext()) {
            if (lengths.nextIndex() > 0) {
                out.append(' ');
            }
            int length = lengths.next();
            while (length-- > 1) {
                out.append(' ');
            }
            out.append(var);
        }
    }

    private static void insert(int i, Value value, List<Integer> values) {
        int length = ByteCodeVerifier.shortName(value.toString()).length();
        while (i >= values.size()) {
            values.add(1);
        }
        if (length > values.get(i)) {
            values.set(i, length);
        }
    }

    private static String shortName(String name) {
        int start = name.lastIndexOf(47);
        int end = name.length();
        if (name.charAt(end - 1) == ';') {
            --end;
        }
        return start == -1 ? name : name.substring(start + 1, end);
    }

    private static boolean isInterfaceNode(ClassNode clazz) {
        return (clazz.access & 0x200) != 0;
    }

    private static class AssignmentChecker {
        private final ClassLoader classpathLoader;
        private final Map<Type, ClassNode> classes = new HashMap<Type, ClassNode>();

        AssignmentChecker(ClassLoader classpathLoader, List<ClassNode> classes) {
            this.classpathLoader = classpathLoader;
            for (ClassNode node : classes) {
                this.classes.put(Type.getObjectType((String)node.name), node);
            }
        }

        boolean invokableInterface(Type target, Type value) {
            ClassNode targetNode = this.classes.get(target);
            if (targetNode != null) {
                if (ByteCodeVerifier.isInterfaceNode(targetNode)) {
                    return value.getSort() == 10 || value.getSort() == 9;
                }
                return false;
            }
            Class<?> targetClass = this.getClass(target);
            if (targetClass.isInterface()) {
                return value.getSort() == 10 || value.getSort() == 9;
            }
            return false;
        }

        boolean isAssignableFrom(Type target, Type value) {
            if (target.equals((Object)value)) {
                return true;
            }
            ClassNode targetNode = this.classes.get(target);
            ClassNode valueNode = this.classes.get(value);
            if (targetNode != null && valueNode == null) {
                return false;
            }
            if (valueNode != null) {
                return this.isAssignableFrom(target, valueNode);
            }
            return this.getClass(target).isAssignableFrom(this.getClass(value));
        }

        private boolean isAssignableFrom(Type target, ClassNode value) {
            if (value.superName != null && this.isAssignableFrom(target, Type.getObjectType((String)value.superName))) {
                return true;
            }
            for (String iFace : value.interfaces) {
                if (!this.isAssignableFrom(target, Type.getObjectType((String)iFace))) continue;
                return true;
            }
            return false;
        }

        private Class<?> getClass(Type type) {
            try {
                if (type.getSort() == 9) {
                    return Class.forName(type.getDescriptor().replace('/', '.'), false, this.classpathLoader);
                }
                return Class.forName(type.getClassName(), false, this.classpathLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    private static class Verifier
    extends SimpleVerifier {
        private final AssignmentChecker check;

        Verifier(ClassNode clazz, AssignmentChecker check) {
            super(Type.getObjectType((String)clazz.name), Verifier.superClass(clazz), Verifier.interfaces(clazz), ByteCodeVerifier.isInterfaceNode(clazz));
            this.check = check;
        }

        protected boolean isAssignableFrom(Type target, Type value) {
            return this.check.isAssignableFrom(target, value);
        }

        protected boolean isSubTypeOf(BasicValue value, BasicValue expected) {
            return super.isSubTypeOf(value, expected) || this.check.invokableInterface(expected.getType(), value.getType());
        }

        private static Type superClass(ClassNode clazz) {
            return clazz.superName == null ? null : Type.getObjectType((String)clazz.superName);
        }

        private static List<Type> interfaces(ClassNode clazz) {
            ArrayList<Type> interfaces = new ArrayList<Type>(clazz.interfaces.size());
            for (String iFace : clazz.interfaces) {
                interfaces.add(Type.getObjectType((String)iFace));
            }
            return interfaces;
        }
    }

    private static class Failure {
        final Throwable cause;
        final String message;

        Failure(Throwable cause, String message) {
            this.cause = cause;
            this.message = message;
        }
    }
}

