/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.List;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public final class ByteCodeUtils {
    private ByteCodeUtils() {
        throw new UnsupportedOperationException();
    }

    public static String byteCodeName(TypeReference reference) {
        StringBuilder builder = new StringBuilder();
        if (!reference.packageName().isEmpty()) {
            builder.append(reference.packageName().replaceAll("\\.", "/")).append('/');
        }
        if (reference.isInnerClass()) {
            builder.append(reference.declaringClassName()).append('$');
        }
        builder.append(reference.simpleName());
        return builder.toString();
    }

    public static String outerName(TypeReference reference) {
        if (!reference.isInnerClass()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (!reference.packageName().isEmpty()) {
            builder.append(reference.packageName().replaceAll("\\.", "/")).append('/');
        }
        builder.append(reference.simpleName());
        return builder.toString();
    }

    public static String typeName(TypeReference reference) {
        StringBuilder builder = new StringBuilder();
        ByteCodeUtils.internalType(builder, reference, false);
        return builder.toString();
    }

    public static String desc(MethodDeclaration declaration) {
        return ByteCodeUtils.internalDesc(declaration.erased(), false);
    }

    public static String desc(MethodReference reference) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (TypeReference parameter : reference.parameters()) {
            ByteCodeUtils.internalType(builder, parameter, false);
        }
        builder.append(")");
        ByteCodeUtils.internalType(builder, reference.returns(), false);
        return builder.toString();
    }

    public static String signature(TypeReference reference) {
        if (!reference.isGeneric()) {
            return null;
        }
        return ByteCodeUtils.internalSignature(reference);
    }

    public static String signature(MethodDeclaration declaration) {
        if (!declaration.isGeneric()) {
            return null;
        }
        return ByteCodeUtils.internalDesc(declaration, true);
    }

    public static String[] exceptions(MethodDeclaration declaration) {
        List<TypeReference> throwsList = declaration.erased().throwsList();
        if (throwsList.isEmpty()) {
            return null;
        }
        return (String[])throwsList.stream().map(ByteCodeUtils::byteCodeName).toArray(String[]::new);
    }

    private static String internalDesc(MethodDeclaration declaration, boolean showErasure) {
        StringBuilder builder = new StringBuilder();
        List<MethodDeclaration.TypeParameter> typeParameters = declaration.typeParameters();
        if (showErasure && !typeParameters.isEmpty()) {
            builder.append("<");
            for (MethodDeclaration.TypeParameter typeParameter : typeParameters) {
                builder.append(typeParameter.name()).append(":");
                ByteCodeUtils.internalType(builder, typeParameter.extendsBound(), true);
            }
            builder.append(">");
        }
        builder.append("(");
        for (Parameter parameter : declaration.parameters()) {
            ByteCodeUtils.internalType(builder, parameter.type(), showErasure);
        }
        builder.append(")");
        ByteCodeUtils.internalType(builder, declaration.returnType(), showErasure);
        List<TypeReference> throwsList = declaration.throwsList();
        if (showErasure && throwsList.stream().anyMatch(TypeReference::isTypeParameter)) {
            builder.append("^");
            throwsList.forEach(t -> ByteCodeUtils.internalType(builder, t, false));
        }
        return builder.toString();
    }

    private static String internalSignature(TypeReference reference) {
        return ByteCodeUtils.internalType(new StringBuilder(), reference, true).toString();
    }

    private static StringBuilder internalType(StringBuilder builder, TypeReference reference, boolean showErasure) {
        String name;
        if (reference.isArray()) {
            builder.append("[");
            name = reference.simpleName().substring(0, reference.simpleName().length() - 2);
        } else {
            name = reference.simpleName();
        }
        switch (name) {
            case "int": {
                builder.append("I");
                break;
            }
            case "long": {
                builder.append("J");
                break;
            }
            case "byte": {
                builder.append("B");
                break;
            }
            case "short": {
                builder.append("S");
                break;
            }
            case "char": {
                builder.append("C");
                break;
            }
            case "float": {
                builder.append("F");
                break;
            }
            case "double": {
                builder.append("D");
                break;
            }
            case "boolean": {
                builder.append("Z");
                break;
            }
            case "void": {
                builder.append("V");
                break;
            }
            default: {
                if (reference.isTypeParameter()) {
                    builder.append("T").append(name);
                } else {
                    builder.append("L");
                    String packageName = reference.packageName().replaceAll("\\.", "\\/");
                    if (!packageName.isEmpty()) {
                        builder.append(packageName).append("/");
                    }
                    if (reference.isInnerClass()) {
                        builder.append(reference.declaringClassName()).append('$');
                    }
                    builder.append(name.replaceAll("\\.", "\\/"));
                }
                List<TypeReference> parameters = reference.parameters();
                if (showErasure && !parameters.isEmpty()) {
                    builder.append("<");
                    parameters.stream().forEach(p -> ByteCodeUtils.internalType(builder, p, true));
                    builder.append(">");
                }
                builder.append(";");
            }
        }
        return builder;
    }
}

