/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.lang.reflect.Modifier;
import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class ByteCodeExpressionVisitor
implements ExpressionVisitor {
    private final MethodVisitor methodVisitor;

    ByteCodeExpressionVisitor(MethodVisitor methodVisitor) {
        this.methodVisitor = methodVisitor;
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments) {
        target.accept(this);
        for (Expression argument : arguments) {
            argument.accept(this);
        }
        if (Modifier.isInterface(method.owner().modifiers())) {
            this.methodVisitor.visitMethodInsn(185, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), true);
        } else if (method.isConstructor()) {
            this.methodVisitor.visitMethodInsn(183, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), false);
        } else {
            this.methodVisitor.visitMethodInsn(182, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), false);
        }
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments) {
        for (Expression argument : arguments) {
            argument.accept(this);
        }
        this.methodVisitor.visitMethodInsn(184, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), false);
    }

    @Override
    public void load(LocalVariable variable) {
        switch (variable.type().simpleName()) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": {
                this.methodVisitor.visitVarInsn(21, variable.index());
                break;
            }
            case "long": {
                this.methodVisitor.visitVarInsn(22, variable.index());
                break;
            }
            case "float": {
                this.methodVisitor.visitVarInsn(23, variable.index());
                break;
            }
            case "double": {
                this.methodVisitor.visitVarInsn(24, variable.index());
                break;
            }
            default: {
                this.methodVisitor.visitVarInsn(25, variable.index());
            }
        }
    }

    @Override
    public void getField(Expression target, FieldReference field) {
        target.accept(this);
        this.methodVisitor.visitFieldInsn(180, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
    }

    @Override
    public void constant(Object value) {
        if (value == null) {
            this.methodVisitor.visitInsn(1);
        } else if (value instanceof Integer) {
            this.pushInteger((Integer)value);
        } else if (value instanceof Byte) {
            this.pushInteger(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.pushInteger(((Short)value).shortValue());
        } else if (value instanceof Long) {
            this.methodVisitor.visitLdcInsn(value);
        } else if (value instanceof Double) {
            this.methodVisitor.visitLdcInsn(value);
        } else if (value instanceof Float) {
            this.methodVisitor.visitLdcInsn(value);
        } else if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            this.methodVisitor.visitInsn(b ? 4 : 3);
        } else {
            this.methodVisitor.visitLdcInsn(value);
        }
    }

    @Override
    public void getStatic(FieldReference field) {
        this.methodVisitor.visitFieldInsn(178, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
    }

    @Override
    public void loadThis(String sourceName) {
        this.methodVisitor.visitVarInsn(25, 0);
    }

    @Override
    public void newInstance(TypeReference type) {
        this.methodVisitor.visitTypeInsn(187, ByteCodeUtils.byteCodeName(type));
        this.methodVisitor.visitInsn(89);
    }

    @Override
    public void not(Expression expression) {
        expression.accept(this);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(154, l0);
        this.methodVisitor.visitInsn(4);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    @Override
    public void ternary(Expression test, Expression onTrue, Expression onFalse) {
        this.ternaryExpression(153, test, onTrue, onFalse);
    }

    @Override
    public void ternaryOnNull(Expression test, Expression onTrue, Expression onFalse) {
        this.ternaryExpression(199, test, onTrue, onFalse);
    }

    @Override
    public void ternaryOnNonNull(Expression test, Expression onTrue, Expression onFalse) {
        this.ternaryExpression(198, test, onTrue, onFalse);
    }

    @Override
    public void equal(Expression lhs, Expression rhs, TypeReference type) {
        switch (type.simpleName()) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": {
                this.compareIntOrReferenceType(lhs, rhs, 160);
                break;
            }
            case "long": {
                this.compareLongOrFloatType(lhs, rhs, 148, 154);
                break;
            }
            case "float": {
                this.compareLongOrFloatType(lhs, rhs, 149, 154);
                break;
            }
            case "double": {
                this.compareLongOrFloatType(lhs, rhs, 151, 154);
                break;
            }
            default: {
                this.compareIntOrReferenceType(lhs, rhs, 166);
            }
        }
    }

    @Override
    public void or(Expression lhs, Expression rhs) {
        lhs.accept(this);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(154, l0);
        rhs.accept(this);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(153, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(4);
        Label l2 = new Label();
        this.methodVisitor.visitJumpInsn(167, l2);
        this.methodVisitor.visitLabel(l1);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l2);
    }

    @Override
    public void and(Expression lhs, Expression rhs) {
        lhs.accept(this);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(153, l0);
        rhs.accept(this);
        this.methodVisitor.visitJumpInsn(153, l0);
        this.methodVisitor.visitInsn(4);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    @Override
    public void addInts(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(96);
    }

    @Override
    public void addLongs(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(97);
    }

    @Override
    public void addDoubles(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(99);
    }

    @Override
    public void gt(Expression lhs, Expression rhs, TypeReference type) {
        switch (type.simpleName()) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": {
                this.compareIntOrReferenceType(lhs, rhs, 164);
                break;
            }
            case "long": {
                this.compareLongOrFloatType(lhs, rhs, 148, 158);
                break;
            }
            case "float": {
                this.compareLongOrFloatType(lhs, rhs, 149, 158);
                break;
            }
            case "double": {
                this.compareLongOrFloatType(lhs, rhs, 151, 158);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compare reference types");
            }
        }
    }

    @Override
    public void subtractInts(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(100);
    }

    @Override
    public void subtractLongs(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(101);
    }

    @Override
    public void subtractDoubles(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(103);
    }

    @Override
    public void multiplyDoubles(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(107);
    }

    @Override
    public void multiplyLongs(Expression lhs, Expression rhs) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(105);
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        expression.accept(this);
        this.methodVisitor.visitTypeInsn(192, ByteCodeUtils.byteCodeName(type));
    }

    @Override
    public void newArray(TypeReference type, Expression ... exprs) {
        this.pushInteger(exprs.length);
        this.createArray(type);
        for (int i = 0; i < exprs.length; ++i) {
            this.methodVisitor.visitInsn(89);
            this.pushInteger(i);
            exprs[i].accept(this);
            this.arrayStore(type);
        }
    }

    @Override
    public void longToDouble(Expression expression) {
        expression.accept(this);
        this.methodVisitor.visitInsn(138);
    }

    @Override
    public void pop(Expression expression) {
        expression.accept(this);
        this.methodVisitor.visitInsn(87);
    }

    private void compareIntOrReferenceType(Expression lhs, Expression rhs, int opcode) {
        lhs.accept(this);
        rhs.accept(this);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(opcode, l0);
        this.methodVisitor.visitInsn(4);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    private void compareLongOrFloatType(Expression lhs, Expression rhs, int opcode, int compare) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(opcode);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(compare, l0);
        this.methodVisitor.visitInsn(4);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    private void pushInteger(int integer) {
        if (integer < 6 && integer >= -1) {
            this.methodVisitor.visitInsn(3 + integer);
        } else if (integer < 127 && integer > -128) {
            this.methodVisitor.visitIntInsn(16, integer);
        } else if (integer < Short.MAX_VALUE && integer > Short.MIN_VALUE) {
            this.methodVisitor.visitIntInsn(17, integer);
        } else {
            this.methodVisitor.visitLdcInsn((Object)integer);
        }
    }

    private void createArray(TypeReference reference) {
        switch (reference.name()) {
            case "int": {
                this.methodVisitor.visitIntInsn(188, 10);
                break;
            }
            case "long": {
                this.methodVisitor.visitIntInsn(188, 11);
                break;
            }
            case "byte": {
                this.methodVisitor.visitIntInsn(188, 8);
                break;
            }
            case "short": {
                this.methodVisitor.visitIntInsn(188, 9);
                break;
            }
            case "char": {
                this.methodVisitor.visitIntInsn(188, 5);
                break;
            }
            case "float": {
                this.methodVisitor.visitIntInsn(188, 6);
                break;
            }
            case "double": {
                this.methodVisitor.visitIntInsn(188, 7);
                break;
            }
            case "boolean": {
                this.methodVisitor.visitIntInsn(188, 4);
                break;
            }
            default: {
                this.methodVisitor.visitTypeInsn(189, ByteCodeUtils.byteCodeName(reference));
            }
        }
    }

    private void arrayStore(TypeReference reference) {
        switch (reference.name()) {
            case "int": {
                this.methodVisitor.visitInsn(79);
                break;
            }
            case "long": {
                this.methodVisitor.visitInsn(80);
                break;
            }
            case "byte": {
                this.methodVisitor.visitInsn(84);
                break;
            }
            case "short": {
                this.methodVisitor.visitInsn(86);
                break;
            }
            case "char": {
                this.methodVisitor.visitInsn(85);
                break;
            }
            case "float": {
                this.methodVisitor.visitInsn(81);
                break;
            }
            case "double": {
                this.methodVisitor.visitInsn(82);
                break;
            }
            case "boolean": {
                this.methodVisitor.visitInsn(84);
                break;
            }
            default: {
                this.methodVisitor.visitInsn(83);
            }
        }
    }

    private void ternaryExpression(int op, Expression test, Expression onTrue, Expression onFalse) {
        test.accept(this);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(op, l0);
        onTrue.accept(this);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        onFalse.accept(this);
        this.methodVisitor.visitLabel(l1);
    }
}

