/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.BaseUri;
import org.neo4j.codegen.source.SourceCode;
import org.neo4j.codegen.source.SourceVisitor;
import org.neo4j.codegen.source.WarningsHandler;

class Configuration {
    private List<Processor> processors = new ArrayList<Processor>();
    private Set<SourceCode> flags = EnumSet.noneOf(SourceCode.class);
    private List<String> options = new ArrayList<String>();
    private List<SourceVisitor> sourceVisitors = new ArrayList<SourceVisitor>();
    private List<WarningsHandler> warningsHandlers = new ArrayList<WarningsHandler>();

    Configuration() {
    }

    public Configuration withAnnotationProcessor(Processor processor) {
        this.processors.add(processor);
        return this;
    }

    public Configuration withFlag(SourceCode flag) {
        this.flags.add(flag);
        return this;
    }

    public Configuration withOptions(String ... opts) {
        if (opts != null) {
            Collections.addAll(this.options, opts);
        }
        return this;
    }

    public Configuration withSourceVisitor(SourceVisitor visitor) {
        this.sourceVisitors.add(visitor);
        return this;
    }

    public Configuration withWarningsHandler(WarningsHandler handler) {
        this.warningsHandlers.add(handler);
        return this;
    }

    public Iterable<String> options() {
        return this.options;
    }

    public void processors(JavaCompiler.CompilationTask task) {
        task.setProcessors(this.processors);
    }

    public Locale locale() {
        return null;
    }

    public Charset chraset() {
        return null;
    }

    public Writer errorWriter() {
        return null;
    }

    public BaseUri sourceBase() {
        return BaseUri.DEFAULT_SOURCE_BASE;
    }

    public boolean isSet(SourceCode flag) {
        return this.flags != null && this.flags.contains(flag);
    }

    public void visit(TypeReference reference, StringBuilder source) {
        for (SourceVisitor visitor : this.sourceVisitors) {
            visitor.visitSource(reference, source);
        }
    }

    public WarningsHandler warningsHandler() {
        if (this.warningsHandlers.isEmpty()) {
            return WarningsHandler.NO_WARNINGS_HANDLER;
        }
        if (this.warningsHandlers.size() == 1) {
            return this.warningsHandlers.get(0);
        }
        return new WarningsHandler.Multiplex(this.warningsHandlers.toArray(new WarningsHandler[this.warningsHandlers.size()]));
    }
}

