/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.OptionalLong;
import org.neo4j.cloud.storage.io.PathBasedOutputStream;
import org.neo4j.cloud.storage.queues.PullQueue;
import org.neo4j.cloud.storage.queues.PushQueue;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.LoggerPrintStreamAdaptor;

public abstract class ReadableChannel
extends InputStream
implements ReadableByteChannel {
    protected final long channelSize;
    protected final int queueBufferSize;
    private final String progressText;
    private final InternalLog log;
    private final PullQueue queue;
    private ByteBuffer buffer;
    private Mark mark;
    private boolean queuePositioned = false;
    protected long position;
    private boolean closed;

    protected ReadableChannel(PullQueue queue, long channelSize, int queueBufferSize, String progressText, InternalLog log) {
        this.channelSize = channelSize;
        this.queueBufferSize = queueBufferSize;
        this.progressText = progressText;
        this.log = log;
        this.queue = queue;
    }

    protected abstract OptionalLong replicateWithinSameProvider(OutputStream var1) throws IOException;

    protected abstract PushQueue newPushQueue(ByteBufferHandler var1, ProgressListener var2);

    public long position() throws IOException {
        this.ensureOpen();
        return this.position;
    }

    public ReadableChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        long newPos = Math.min(newPosition, this.channelSize);
        if (this.buffer == null) {
            this.queuePositioned = false;
        } else if (newPos < this.position - (long)this.buffer.position() || newPos >= this.position + (long)this.buffer.remaining()) {
            this.buffer = this.queue.positionAndGet(newPos);
        } else {
            int diff = (int)(newPos - this.position);
            this.buffer.position(this.buffer.position() + diff);
        }
        this.position = newPos;
        return this;
    }

    public long size() throws IOException {
        this.ensureOpen();
        return this.channelSize;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (!this.closed) {
            this.mark = new Mark(this.position, readLimit);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == null) {
            throw new IOException("No mark has been set on this stream");
        }
        long limit = this.mark.limit();
        if (this.position > limit) {
            throw new IOException("The stream has exceeded the read limit of %d from the mark at %d by %d byte(s)".formatted(this.mark.readLimit, this.mark.position, this.position - limit));
        }
        this.position(this.mark.position);
        this.mark = null;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long prevPos = this.position;
        long newPos = this.position + n;
        this.position(newPos);
        return newPos > this.channelSize ? this.channelSize - prevPos : n;
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        long skipped;
        if (n > 0L && (skipped = this.skip(n)) < n) {
            throw new EOFException("Skipping %d bytes took the stream passed the end of the file at %d bytes".formatted(n, this.channelSize));
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        ByteBuffer current = this.currentBuffer();
        while (current != null) {
            if (current.hasRemaining()) {
                int b = current.get() & 0xFF;
                ++this.position;
                return b;
            }
            current = this.nextBuffer();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.ensureOpen();
        ByteBuffer current = this.currentBuffer();
        if (current == null) {
            return -1;
        }
        int read = 0;
        while (read < length) {
            if (current.hasRemaining()) {
                int toRead = Math.min(length - read, current.remaining());
                current.get(bytes, offset + read, toRead);
                this.position += (long)toRead;
                read += toRead;
                continue;
            }
            current = this.nextBuffer();
            if (current != null) continue;
            return read == 0 ? -1 : read;
        }
        return read;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        ByteBuffer current = this.currentBuffer();
        if (current == null) {
            return -1;
        }
        int read = 0;
        while (dst.hasRemaining()) {
            if (current.hasRemaining()) {
                int toRead = Math.min(current.remaining(), dst.remaining());
                int dstPos = dst.position();
                int srcPos = current.position();
                dst.put(dstPos, current, srcPos, toRead).position(dstPos + toRead);
                current.position(srcPos + toRead);
                this.position += (long)toRead;
                read += toRead;
                continue;
            }
            current = this.nextBuffer();
            if (current != null) continue;
            return read == 0 ? -1 : read;
        }
        return read;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        long transferred;
        this.ensureOpen();
        OptionalLong replicatedBytes = this.replicateWithinSameProvider(out);
        if (replicatedBytes.isPresent()) {
            return replicatedBytes.getAsLong();
        }
        if (out instanceof PathBasedOutputStream) {
            PathBasedOutputStream pathOut = (PathBasedOutputStream)out;
            transferred = this.download(pathOut);
        } else {
            transferred = this.download(out);
        }
        this.position = this.channelSize;
        return transferred;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.queue.close();
            this.closed = true;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    private ByteBuffer currentBuffer() throws IOException {
        if (this.buffer == null) {
            if (!this.queuePositioned) {
                this.queuePositioned = true;
                this.buffer = this.queue.positionAndGet(this.position);
            } else {
                this.buffer = this.queue.get();
            }
        }
        return this.buffer;
    }

    private ByteBuffer nextBuffer() throws IOException {
        assert (this.queuePositioned);
        this.buffer = this.queue.get();
        return this.buffer;
    }

    private long download(PathBasedOutputStream output) throws IOException {
        long actualSize = this.channelSize - this.position;
        output.replicate((ThrowingConsumer<Path, IOException>)((ThrowingConsumer)path -> {
            try (FileChannel channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                 ProgressListener progress = this.progressListener(actualSize);
                 PushQueue queue = this.newPushQueue(channel::write, progress);){
                queue.run();
            }
        }));
        return actualSize;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long download(OutputStream out) throws IOException {
        long actualSize = this.channelSize - this.position;
        this.log.warn("Downloading %s of a file in chunks of %s - consider using a path based output stream", new Object[]{ByteUnit.bytesToString((long)actualSize), ByteUnit.bytesToString((long)this.queueBufferSize)});
        try (ProgressListener progress = this.progressListener(actualSize);){
            long l;
            block14: {
                PushQueue queue = this.newPushQueue(this.handlerForOutputStream(out), progress);
                try {
                    queue.run();
                    l = actualSize;
                    if (queue == null) break block14;
                }
                catch (Throwable throwable) {
                    if (queue != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                queue.close();
            }
            return l;
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    private ByteBufferHandler handlerForOutputStream(OutputStream out) {
        byte[] bytes = new byte[this.queueBufferSize];
        return data -> {
            int length = data.remaining();
            if (data.hasArray()) {
                out.write(data.array(), 0, length);
            } else {
                data.get(bytes, 0, length);
                out.write(bytes, 0, length);
            }
            return length;
        };
    }

    private ProgressListener progressListener(long totalCount) {
        return ProgressMonitorFactory.textual((OutputStream)new LoggerPrintStreamAdaptor(this.log, Level.INFO)).singlePart(this.progressText, totalCount);
    }

    private record Mark(long position, int readLimit) {
        private long limit() {
            return this.position + (long)this.readLimit;
        }
    }

    @FunctionalInterface
    public static interface ByteBufferHandler {
        public long apply(ByteBuffer var1) throws IOException;
    }
}

