/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.cloud.storage.PathRepresentation;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.cloud.storage.StorageSystemProvider;

public abstract class StorageSystem
extends FileSystem {
    public static final String BASIC_FILE_ATTRIBUTE_VIEW = "basic";
    private final StorageSystemProvider provider;
    private boolean open = true;

    protected StorageSystem(StorageSystemProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    protected abstract String uriPrefix();

    protected abstract void internalClose() throws IOException;

    protected abstract boolean supportsEmptyDirs();

    public abstract boolean canResolve(StoragePath var1);

    public String scheme() {
        return this.provider.getScheme();
    }

    @Override
    public StorageSystemProvider provider() {
        return this.provider;
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new StoragePath(this, PathRepresentation.of(first, more));
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.getPath("/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of(BASIC_FILE_ATTRIBUTE_VIEW);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("getUserPrincipalLookupService");
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException("newWatchService");
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            try {
                this.internalClose();
            }
            finally {
                this.open = false;
            }
        }
    }
}

