/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.cloud.storage.StorageSystem;
import org.neo4j.cloud.storage.StorageSystemProviderFactory;
import org.neo4j.cloud.storage.StorageUtils;
import org.neo4j.configuration.Config;
import org.neo4j.io.IOUtils;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public abstract class StorageSystemProvider
extends FileSystemProvider
implements AutoCloseable {
    private final MutableMap<URI, StorageSystem> systems = Maps.mutable.empty();
    protected final String scheme;
    protected final StorageSystemProviderFactory.ChunkChannelSupplier tempSupplier;
    protected final Config config;
    protected final InternalLogProvider logProvider;
    protected final MemoryTracker memoryTracker;

    protected StorageSystemProvider(String scheme, StorageSystemProviderFactory.ChunkChannelSupplier tempSupplier, Config config, InternalLogProvider logProvider, MemoryTracker memoryTracker) {
        this.scheme = Objects.requireNonNull(scheme);
        this.tempSupplier = Objects.requireNonNull(tempSupplier);
        this.config = Objects.requireNonNull(config);
        this.logProvider = Objects.requireNonNull(logProvider);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
    }

    protected abstract SeekableByteChannel openAsByteChannel(StoragePath var1, Set<? extends OpenOption> var2) throws IOException;

    protected abstract OutputStream openAsOutputStream(StoragePath var1, Set<? extends OpenOption> var2) throws IOException;

    protected abstract InputStream openAsInputStream(StoragePath var1) throws IOException;

    protected abstract StorageSystem create(URI var1);

    protected abstract StorageLocation resolve(URI var1);

    public StorageSystem getStorageSystem(URI uri) {
        return this.internalCreateFileSystem(this.resolve((URI)this.checkScheme((URI)uri)).systemUri);
    }

    public SeekableByteChannel newByteChannel(StoragePath path, Set<? extends OpenOption> options) throws IOException {
        return this.openAsByteChannel(this.ensureNotDirectory(path), options);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        URI systemUri = this.resolve((URI)this.checkScheme((URI)uri)).systemUri;
        if (this.systems.containsKey((Object)systemUri)) {
            throw new FileSystemAlreadyExistsException("Storage system already exists for the system URI : " + systemUri);
        }
        return this.internalCreateFileSystem(systemUri);
    }

    @Override
    public StorageSystem getFileSystem(URI uri) {
        return this.internalGetFileSystem(this.resolve((URI)this.checkScheme((URI)uri)).systemUri);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return this.openAsOutputStream(this.ensureNotDirectory(path), StorageUtils.normalizeForWrite(options));
    }

    @Override
    public Path getPath(URI uri) {
        StorageLocation resolved = this.resolve(this.checkScheme(uri));
        return this.internalGetFileSystem(resolved.systemUri).getPath(resolved.resourcePath, new String[0]);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.copy(source, target, options);
        this.delete(source);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.toRealPath(LinkOption.NOFOLLOW_LINKS).equals(path2.toRealPath(LinkOption.NOFOLLOW_LINKS));
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        return null;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new UnsupportedOperationException("setAttribute");
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Set<OpenOption> normalized = options.contains(StandardOpenOption.WRITE) ? StorageUtils.normalizeForWrite(options) : StorageUtils.normalizeForRead(options);
        return this.newByteChannel(this.ensureNotDirectory(path), normalized);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Preconditions.checkArgument((!StorageUtils.normalizeForRead(options).contains(StandardOpenOption.WRITE) ? 1 : 0) != 0, (String)"Opening for WRITE is not allowed");
        return this.openAsInputStream(this.ensureNotDirectory(path));
    }

    @Override
    public void close() {
        try {
            IOUtils.closeAllUnchecked((Collection)this.systems.values());
        }
        finally {
            this.systems.clear();
        }
    }

    protected StoragePath ensureCorrectPath(Path path) {
        Preconditions.checkArgument((boolean)(path instanceof StoragePath), (String)"Path provided must be a storage path");
        return this.ensureCorrectPath((StoragePath)path);
    }

    protected StoragePath ensureCorrectPath(StoragePath storagePath) {
        Objects.requireNonNull(storagePath, "Path must not be null");
        Preconditions.checkArgument((boolean)storagePath.scheme().equals(this.getScheme()), (String)"Path provided must have the correct scheme for this storage system");
        return storagePath;
    }

    protected StoragePath ensureNotDirectory(Path path) throws IOException {
        return this.ensureNotDirectory(this.ensureCorrectPath(path));
    }

    protected StoragePath ensureNotDirectory(StoragePath path) throws IOException {
        StoragePath storagePath = this.ensureCorrectPath(path);
        if (storagePath.isDirectory()) {
            throw new IOException("Path provided is a directory but must be a regular file: " + storagePath);
        }
        return storagePath;
    }

    private URI checkScheme(URI uri) {
        String uriScheme = uri.getScheme();
        Preconditions.checkArgument((boolean)this.scheme.equals(uriScheme), (String)"Invalid scheme provided: expected '%s' but found '%s'".formatted(this.scheme, uriScheme));
        return uri;
    }

    private StorageSystem internalGetFileSystem(URI systemUri) {
        StorageSystem system = (StorageSystem)this.systems.get((Object)systemUri);
        if (system == null) {
            throw new FileSystemNotFoundException("Unable to find the storage system for the system URI: " + systemUri);
        }
        return system;
    }

    private StorageSystem internalCreateFileSystem(URI systemUri) {
        return (StorageSystem)this.systems.getIfAbsentPut((Object)systemUri, (Function0 & Serializable)() -> this.create(systemUri));
    }

    public record StorageLocation(URI systemUri, String resourcePath) {
    }
}

