/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.util.Preconditions;

public class StorageChannel
implements StoreChannel {
    private final SeekableByteChannel channel;

    public StorageChannel(SeekableByteChannel channel) {
        this.channel = channel;
    }

    public StorageChannel position(long newPosition) throws IOException {
        this.internalPosition(newPosition);
        return this;
    }

    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    public long write(ByteBuffer ... srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Preconditions.checkArgument((offset >= 0 && offset < srcs.length ? 1 : 0) != 0, (String)"Offset must be within the range of buffers provided");
        Preconditions.checkArgument((offset + length <= srcs.length ? 1 : 0) != 0, (String)"Length must be within the range of buffers provided");
        long written = 0L;
        for (int i = offset; i < offset + length; ++i) {
            written += (long)this.doWrite(srcs[i]);
        }
        return written;
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException("Not supported in storage channels");
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.doWrite(src);
    }

    public StorageChannel truncate(long size) throws IOException {
        this.channel.truncate(size);
        return this;
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        return this.position(position).read(dst);
    }

    public void readAll(ByteBuffer dst) throws IOException {
        while (dst.hasRemaining()) {
            if (this.channel.read(dst) >= 0) continue;
            throw new IllegalStateException("Channel has reached end-of-stream.");
        }
    }

    public void readAll(ByteBuffer dst, long position) throws IOException {
        throw new UnsupportedOperationException("Not supported in storage channels");
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long read = 0L;
        for (int i = offset; i < offset + length; ++i) {
            int r = this.read(dsts[i]);
            if (r == -1) {
                return read == 0L ? -1L : read;
            }
            read += (long)r;
        }
        return read;
    }

    public long position() throws IOException {
        return this.channel.position();
    }

    public FileLock tryLock() {
        throw new UnsupportedOperationException("tryLock");
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public int getFileDescriptor() {
        return -1;
    }

    public boolean hasPositionLock() {
        return false;
    }

    public Object getPositionLock() {
        throw new UnsupportedOperationException("getPositionLock");
    }

    public void tryMakeUninterruptible() {
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
        this.force(false);
    }

    public void force(boolean metaData) throws IOException {
        SeekableByteChannel seekableByteChannel = this.channel;
        if (seekableByteChannel instanceof Flushable) {
            Flushable flushable = (Flushable)((Object)seekableByteChannel);
            flushable.flush();
        }
    }

    public void close() throws IOException {
        this.channel.close();
    }

    private int doWrite(ByteBuffer src) throws IOException {
        int bytesWritten;
        int total;
        int bytesToWrite = total = src.limit() - src.position();
        while ((bytesToWrite -= (bytesWritten = this.write(src))) > 0) {
            if (bytesWritten >= 0) continue;
            throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
        }
        return total;
    }

    private void internalPosition(long newPosition) throws IOException {
        this.channel.position(newPosition);
    }
}

