/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.capabilities.Capability;

final class CapabilityInstance<T> {
    private final Capability<T> capability;
    private volatile Supplier<T> value;

    CapabilityInstance(Capability<T> capability) {
        this.capability = Objects.requireNonNull(capability);
        this.value = null;
    }

    Capability<T> capability() {
        return this.capability;
    }

    T get() {
        Supplier<T> localValue = this.value;
        if (localValue == null) {
            return null;
        }
        return localValue.get();
    }

    void set(T value) {
        this.value = () -> value;
    }

    void supply(Supplier<T> value) {
        this.value = value;
    }
}

