/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.neo4j.annotations.Description;
import org.neo4j.annotations.Public;
import org.neo4j.capabilities.Capabilities;
import org.neo4j.capabilities.CapabilitiesRegistry;
import org.neo4j.capabilities.CapabilitiesSettings;
import org.neo4j.capabilities.Capability;
import org.neo4j.capabilities.CapabilityDeclaration;
import org.neo4j.capabilities.CapabilityInstance;
import org.neo4j.capabilities.CapabilityProvider;
import org.neo4j.capabilities.CapabilityProviderContext;
import org.neo4j.capabilities.CapabilityProviderDependencies;
import org.neo4j.capabilities.Name;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.service.Services;

public class CapabilitiesService
extends LifecycleAdapter
implements CapabilitiesRegistry {
    private final Map<Name, CapabilityInstance<?>> capabilities;
    private final Collection<CapabilityProvider> capabilityProviders;
    private final DependencyResolver resolver;
    private final Configuration config;

    CapabilitiesService(@Nonnull Collection<Class<? extends CapabilityDeclaration>> declarationClasses, @Nonnull Collection<CapabilityProvider> capabilityProviders, @Nonnull Configuration config, @Nonnull DependencyResolver resolver) {
        this.capabilities = CapabilitiesService.getDeclaredCapabilities(Objects.requireNonNull(declarationClasses)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new CapabilityInstance((Capability)e.getValue())));
        this.capabilityProviders = Objects.requireNonNull(capabilityProviders);
        this.config = Objects.requireNonNull(config);
        this.resolver = Objects.requireNonNull(resolver);
    }

    public Collection<Capability<?>> declaredCapabilities() {
        List blocked = (List)this.config.get(CapabilitiesSettings.dbms_capabilities_blocked);
        return this.capabilities.values().stream().map(CapabilityInstance::capability).filter(capability -> !capability.name().matches(blocked)).collect(Collectors.toList());
    }

    @Override
    public <T> T get(@Nonnull Capability<T> capability) {
        return (T)this.get(capability.name());
    }

    @Override
    public Object get(@Nonnull Name name) {
        if (name.matches((List)this.config.get(CapabilitiesSettings.dbms_capabilities_blocked))) {
            return null;
        }
        CapabilityInstance instance = this.capabilities.getOrDefault(name, null);
        if (instance == null) {
            return null;
        }
        return instance.get();
    }

    @Override
    public <T> void set(@Nonnull Capability<T> capability, @Nonnull T value) {
        CapabilityInstance instance = this.capabilities.getOrDefault(capability.name(), null);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("unknown capability %s", capability.name()));
        }
        instance.set(value);
    }

    @Override
    public <T> void supply(@Nonnull Capability<T> capability, @Nonnull Supplier<T> dynamicValue) {
        CapabilityInstance instance = this.capabilities.getOrDefault(capability.name(), null);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("unknown capability %s", capability.name()));
        }
        instance.supply(dynamicValue);
    }

    public Capabilities unmodifiable() {
        return new UnmodifiableCapabilities();
    }

    void processProviders() {
        CapabilityProviderDependencies dependencies = new CapabilityProviderDependencies();
        dependencies.register(Configuration.class, () -> (Configuration)this.resolver.resolveDependency(Configuration.class));
        dependencies.register(Log.class, () -> ((LogService)this.resolver.resolveDependency(LogService.class)).getUserLog(Capabilities.class));
        dependencies.register(DatabaseManagementService.class, () -> (DatabaseManagementService)this.resolver.resolveDependency(DatabaseManagementService.class));
        this.capabilityProviders.forEach(p -> p.register(new CapabilityProviderContext(dependencies), new NamespaceAwareCapabilityRegistry(p.namespace())));
    }

    public void start() throws Exception {
        this.processProviders();
    }

    public static CapabilitiesService newCapabilities(Configuration config, DependencyResolver resolver) {
        Collection declarationClasses = Services.loadAll(CapabilityDeclaration.class).stream().map(Object::getClass).collect(Collectors.toList());
        Collection capabilityProviders = Services.loadAll(CapabilityProvider.class);
        return new CapabilitiesService(declarationClasses, capabilityProviders, config, resolver);
    }

    private static Map<Name, Capability<?>> getDeclaredCapabilities(Collection<Class<? extends CapabilityDeclaration>> declarationClasses) {
        HashMap capabilities = new HashMap();
        for (Class<? extends CapabilityDeclaration> declarationClass : declarationClasses) {
            CapabilitiesService.getDeclaredCapabilities(declarationClass).forEach((name, capability) -> capabilities.merge((Name)name, (Capability<?>)capability, (oldValue, newValue) -> {
                throw new UnsupportedOperationException(String.format("duplicate capability %s", name));
            }));
        }
        return capabilities;
    }

    private static Map<Name, Capability<?>> getDeclaredCapabilities(Class<?> declarationClass) {
        HashMap capabilities = new HashMap();
        Arrays.stream(FieldUtils.getAllFields(declarationClass)).filter(field -> field.getType().isAssignableFrom(Capability.class)).forEach(field -> {
            try {
                Capability capability = (Capability)field.get(null);
                if (field.isAnnotationPresent(Description.class)) {
                    capability.setDescription(field.getAnnotation(Description.class).value());
                }
                if (field.isAnnotationPresent(Public.class)) {
                    capability.setPublic();
                }
                capabilities.put(capability.name(), capability);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("%s %s, from %s is not accessible.", field.getType(), field.getName(), declarationClass.getSimpleName()), e);
            }
        });
        return capabilities;
    }

    private class NamespaceAwareCapabilityRegistry
    implements CapabilitiesRegistry {
        private final String namespace;

        private NamespaceAwareCapabilityRegistry(String namespace) {
            this.namespace = Objects.requireNonNull(namespace);
        }

        @Override
        public <T> T get(@Nonnull Capability<T> capability) {
            return CapabilitiesService.this.get(capability);
        }

        @Override
        public Object get(@Nonnull Name name) {
            return CapabilitiesService.this.get(name);
        }

        @Override
        public <T> void set(@Nonnull Capability<T> capability, @Nonnull T value) {
            if (!capability.name().isIn(this.namespace)) {
                throw new IllegalArgumentException(String.format("provided capability %s is not in declared namespace %s", capability.name(), this.namespace));
            }
            CapabilitiesService.this.set(capability, value);
        }

        @Override
        public <T> void supply(@Nonnull Capability<T> capability, @Nonnull Supplier<T> dynamicValue) {
            if (!capability.name().isIn(this.namespace)) {
                throw new IllegalArgumentException(String.format("provided capability %s is not in declared namespace %s", capability.name(), this.namespace));
            }
            CapabilitiesService.this.supply(capability, dynamicValue);
        }
    }

    private class UnmodifiableCapabilities
    implements Capabilities {
        private UnmodifiableCapabilities() {
        }

        @Override
        public <T> T get(@Nonnull Capability<T> capability) {
            return CapabilitiesService.this.get(capability);
        }

        @Override
        public Object get(@Nonnull Name name) {
            return CapabilitiesService.this.get(name);
        }
    }
}

