/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.Objects;
import org.neo4j.capabilities.Name;
import org.neo4j.capabilities.Type;

public final class Capability<T> {
    private final Name name;
    private final Type<T> type;
    private boolean internal;
    private String description;

    public Capability(Name name, Type<T> type) {
        this(name, type, "", true);
    }

    private Capability(Name name, Type<T> type, String description, boolean internal) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.description = Objects.requireNonNull(description);
        this.internal = internal;
    }

    public Name name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean internal() {
        return this.internal;
    }

    public Type<T> type() {
        return this.type;
    }

    void setDescription(String description) {
        this.description = Objects.requireNonNull(description);
    }

    void setPublic() {
        this.internal = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capability that = (Capability)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Capability{name=" + String.valueOf(this.name) + ", type=" + String.valueOf(this.type) + "}";
    }
}

