/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticAnalysisTooling;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheck;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheck$;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckable;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.Symbol;
import org.neo4j.cypher.internal.expressions.DoubleLiteral;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.Literal;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.PathExpression;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.expressions.SubqueryExpression;
import org.neo4j.cypher.internal.expressions.TypeSignature;
import org.neo4j.cypher.internal.expressions.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.TypeSpec;
import org.neo4j.cypher.internal.util.symbols.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ASTSlicingPhrase$
implements SemanticAnalysisTooling {
    public static final ASTSlicingPhrase$ MODULE$ = new ASTSlicingPhrase$();

    static {
        SemanticAnalysisTooling.$init$(MODULE$);
    }

    @Override
    public <A> SemanticCheck semanticCheckFold(Iterable<A> iterable, Function1<A, SemanticCheck> f) {
        return SemanticAnalysisTooling.semanticCheckFold$(this, iterable, f);
    }

    @Override
    public <A extends SemanticCheckable> SemanticCheck semanticCheck(IterableOnce<A> iterable) {
        return SemanticAnalysisTooling.semanticCheck$(this, iterable);
    }

    @Override
    public SemanticCheck withState(SemanticState state, SemanticCheck check2) {
        return SemanticAnalysisTooling.withState$(this, state, check2);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> specifyType(Function1<SemanticState, TypeSpec> typeGen, Expression expression) {
        return SemanticAnalysisTooling.specifyType$((SemanticAnalysisTooling)this, typeGen, expression);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> specifyType(Function0<TypeSpec> possibleTypes, Expression expression) {
        return SemanticAnalysisTooling.specifyType$((SemanticAnalysisTooling)this, possibleTypes, expression);
    }

    @Override
    public SemanticCheck expectType(Function1<SemanticState, TypeSpec> typeGen, Expression expression) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, typeGen, expression);
    }

    @Override
    public SemanticCheck expectType(TypeSpec possibleTypes, Option<Expression> opt) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, opt);
    }

    @Override
    public SemanticCheck expectType(Function1<SemanticState, TypeSpec> typeGen, Expression expression, Function2<String, String, String> messageGen) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, typeGen, expression, messageGen);
    }

    @Override
    public <Exp extends Expression> SemanticCheck expectType(TypeSpec possibleTypes, Iterable<Exp> expressions) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expressions);
    }

    @Override
    public SemanticCheck expectType(Function0<TypeSpec> possibleTypes, Expression.SemanticContext ctx, Expression expr) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, ctx, expr);
    }

    @Override
    public SemanticCheck expectType(Function0<TypeSpec> possibleTypes, Expression expression) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expression);
    }

    @Override
    public SemanticCheck expectType(Function0<TypeSpec> possibleTypes, Expression expression, Function2<String, String, String> messageGen) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expression, messageGen);
    }

    @Override
    public SemanticCheckResult expectType(SemanticState s, Function0<TypeSpec> possibleTypes, Expression expression, Function2<String, String, String> messageGen) {
        return SemanticAnalysisTooling.expectType$(this, s, possibleTypes, expression, messageGen);
    }

    @Override
    public Function2<String, String, String> expectType$default$4() {
        return SemanticAnalysisTooling.expectType$default$4$(this);
    }

    @Override
    public SemanticCheck checkTypes(Expression expression, Seq<TypeSignature> signatures) {
        return SemanticAnalysisTooling.checkTypes$(this, expression, signatures);
    }

    @Override
    public SemanticCheck whenState(Function1<SemanticState, Object> condition, Function0<SemanticCheck> thenBranch, Function0<SemanticCheck> elseBranch) {
        return SemanticAnalysisTooling.whenState$(this, condition, thenBranch, elseBranch);
    }

    @Override
    public SemanticCheck whenState$default$3(Function1<SemanticState, Object> condition) {
        return SemanticAnalysisTooling.whenState$default$3$(this, condition);
    }

    @Override
    public SemanticCheck unless(boolean condition, Function0<SemanticCheck> check2) {
        return SemanticAnalysisTooling.unless$(this, condition, check2);
    }

    @Override
    public Function1<SemanticState, TypeSpec> unionOfTypes(IterableOnce<Expression> iterable) {
        return SemanticAnalysisTooling.unionOfTypes$(this, iterable);
    }

    @Override
    public Function1<SemanticState, TypeSpec> leastUpperBoundsOfTypes(IterableOnce<Expression> iterable) {
        return SemanticAnalysisTooling.leastUpperBoundsOfTypes$(this, iterable);
    }

    @Override
    public SemanticCheck withScopedState(Function0<SemanticCheck> check2) {
        return SemanticAnalysisTooling.withScopedState$(this, check2);
    }

    @Override
    public SemanticCheck withScopedStateWithVariablesFromRecordedScope(ASTNode astNode, Set<String> exclude, Function0<SemanticCheck> check2) {
        return SemanticAnalysisTooling.withScopedStateWithVariablesFromRecordedScope$(this, astNode, exclude, check2);
    }

    @Override
    public Set<String> withScopedStateWithVariablesFromRecordedScope$default$2() {
        return SemanticAnalysisTooling.withScopedStateWithVariablesFromRecordedScope$default$2$(this);
    }

    @Override
    public SemanticCheck typeSwitch(Expression expr, Function1<TypeSpec, SemanticCheck> choice) {
        return SemanticAnalysisTooling.typeSwitch$(this, expr, choice);
    }

    @Override
    public boolean validNumber(IntegerLiteral integerLiteral) {
        return SemanticAnalysisTooling.validNumber$((SemanticAnalysisTooling)this, integerLiteral);
    }

    @Override
    public boolean validNumber(DoubleLiteral doubleLiteral) {
        return SemanticAnalysisTooling.validNumber$((SemanticAnalysisTooling)this, doubleLiteral);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> ensureDefined(LogicalVariable v) {
        return SemanticAnalysisTooling.ensureDefined$(this, v);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> declareVariable(LogicalVariable v, TypeSpec possibleTypes) {
        return SemanticAnalysisTooling.declareVariable$(this, v, possibleTypes);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> declareVariable(LogicalVariable v, Function1<SemanticState, TypeSpec> typeGen, Option<Symbol> maybePreviousDeclaration, boolean overriding) {
        return SemanticAnalysisTooling.declareVariable$(this, v, typeGen, maybePreviousDeclaration, overriding);
    }

    @Override
    public Option<Symbol> declareVariable$default$3() {
        return SemanticAnalysisTooling.declareVariable$default$3$(this);
    }

    @Override
    public boolean declareVariable$default$4() {
        return SemanticAnalysisTooling.declareVariable$default$4$(this);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> implicitVariable(LogicalVariable v, CypherType possibleType) {
        return SemanticAnalysisTooling.implicitVariable$(this, v, possibleType);
    }

    @Override
    public SemanticCheck declareVariables(Iterable<Symbol> symbols) {
        return SemanticAnalysisTooling.declareVariables$(this, symbols);
    }

    @Override
    public SemanticCheck recordCurrentScope(ASTNode astNode) {
        return SemanticAnalysisTooling.recordCurrentScope$(this, astNode);
    }

    @Override
    public SemanticCheck requireFeatureSupport(String msg, SemanticFeature feature, InputPosition position) {
        return SemanticAnalysisTooling.requireFeatureSupport$(this, msg, feature, position);
    }

    @Override
    public SemanticCheck error(String msg, InputPosition position) {
        return SemanticAnalysisTooling.error$(this, msg, position);
    }

    @Override
    public SemanticCheck warn(InternalNotification notification) {
        return SemanticAnalysisTooling.warn$(this, notification);
    }

    @Override
    public Function1<SemanticState, TypeSpec> possibleTypes(Expression expression) {
        return SemanticAnalysisTooling.possibleTypes$(this, expression);
    }

    @Override
    public Function1<SemanticState, TypeSpec> types(Expression expression) {
        return SemanticAnalysisTooling.types$(this, expression);
    }

    public SemanticCheck checkExpressionIsStaticInt(Expression expression, String name, boolean acceptsZero) {
        return this.doesNotTouchTheGraph(expression, name).ifOkChain((Function0<SemanticCheck>)(Function0 & Serializable)() -> MODULE$.containsNoVariables(expression, name)).chain(this.literalShouldBeUnsignedInteger(expression, name, acceptsZero)).chain(SemanticExpressionCheck$.MODULE$.simple(expression)).chain(this.expectType((Function0<TypeSpec>)(Function0 & Serializable)() -> package$.MODULE$.CTInteger().covariant(), expression));
    }

    private SemanticCheck containsNoVariables(Expression expression, String name) {
        Set deps = expression.dependencies();
        if (deps.nonEmpty()) {
            LogicalVariable id = (LogicalVariable)deps.toSeq().minBy((Function1 & Serializable)x$1 -> x$1.position(), InputPosition$.MODULE$.byOffset());
            return this.error("It is not allowed to refer to variables in " + name, id.position());
        }
        return SemanticCheck$.MODULE$.success();
    }

    private SemanticCheck doesNotTouchTheGraph(Expression expression, String name) {
        boolean badExpressionFound = expression.folder().treeExists((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SubqueryExpression ? true : A1 instanceof PathExpression) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object instanceof SubqueryExpression ? true : object instanceof PathExpression;
            }
        });
        return SemanticCheck$.MODULE$.when(badExpressionFound, (Function0<SemanticCheck>)(Function0 & Serializable)() -> MODULE$.error("It is not allowed to refer to variables in " + name, expression.position()));
    }

    private SemanticCheck literalShouldBeUnsignedInteger(Expression expression, String name, boolean acceptsZero) {
        SemanticCheck semanticCheck;
        block7: {
            try {
                boolean bl = false;
                SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = null;
                Expression expression2 = expression;
                if (expression2 instanceof UnsignedDecimalIntegerLiteral) {
                    semanticCheck = SemanticCheck$.MODULE$.success();
                    break block7;
                }
                if (expression2 instanceof SignedDecimalIntegerLiteral) {
                    bl = true;
                    signedDecimalIntegerLiteral = (SignedDecimalIntegerLiteral)expression2;
                    if (Predef$.MODULE$.Long2long(signedDecimalIntegerLiteral.value()) > 0L) {
                        semanticCheck = SemanticCheck$.MODULE$.success();
                        break block7;
                    }
                }
                if (bl && BoxesRunTime.equalsNumObject((Number)signedDecimalIntegerLiteral.value(), (Object)BoxesRunTime.boxToInteger((int)0)) && acceptsZero) {
                    semanticCheck = SemanticCheck$.MODULE$.success();
                    break block7;
                }
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    String accepted = acceptsZero ? "non-negative" : "positive";
                    semanticCheck = this.error("Invalid input. '" + ((ASTNode)literal).asCanonicalStringVal() + "' is not a valid value. Must be a " + accepted + " integer.", ((ASTNode)literal).position());
                    break block7;
                }
                semanticCheck = SemanticCheck$.MODULE$.success();
            }
            catch (NumberFormatException numberFormatException) {
                semanticCheck = SemanticCheck$.MODULE$.success();
            }
        }
        return semanticCheck;
    }

    private ASTSlicingPhrase$() {
    }
}

