/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.prettifier;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.ActionResource;
import org.neo4j.cypher.internal.ast.AllGraphsScope;
import org.neo4j.cypher.internal.ast.AllLabelResource;
import org.neo4j.cypher.internal.ast.AllPropertyResource;
import org.neo4j.cypher.internal.ast.AllQualifier;
import org.neo4j.cypher.internal.ast.DefaultDatabaseScope;
import org.neo4j.cypher.internal.ast.ElementsAllQualifier;
import org.neo4j.cypher.internal.ast.ElementsQualifier;
import org.neo4j.cypher.internal.ast.GraphScope;
import org.neo4j.cypher.internal.ast.LabelAllQualifier;
import org.neo4j.cypher.internal.ast.LabelQualifier;
import org.neo4j.cypher.internal.ast.LabelsQualifier;
import org.neo4j.cypher.internal.ast.LabelsResource;
import org.neo4j.cypher.internal.ast.NamedGraphScope;
import org.neo4j.cypher.internal.ast.PrivilegeQualifier;
import org.neo4j.cypher.internal.ast.PropertiesResource;
import org.neo4j.cypher.internal.ast.PropertyResource;
import org.neo4j.cypher.internal.ast.RelationshipAllQualifier;
import org.neo4j.cypher.internal.ast.RelationshipQualifier;
import org.neo4j.cypher.internal.ast.RelationshipsQualifier;
import org.neo4j.cypher.internal.ast.ShowAllPrivileges;
import org.neo4j.cypher.internal.ast.ShowPrivilegeScope;
import org.neo4j.cypher.internal.ast.ShowRolePrivileges;
import org.neo4j.cypher.internal.ast.ShowUserPrivileges;
import org.neo4j.cypher.internal.ast.UserAllQualifier;
import org.neo4j.cypher.internal.ast.UserQualifier;
import org.neo4j.cypher.internal.ast.UsersQualifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$EmptyExtension$;
import org.neo4j.cypher.internal.expressions.Parameter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Prettifier$
implements scala.Serializable {
    public static Prettifier$ MODULE$;

    static {
        new Prettifier$();
    }

    public Prettifier.ClausePrettifier $lessinit$greater$default$2() {
        return Prettifier$EmptyExtension$.MODULE$;
    }

    public boolean $lessinit$greater$default$3() {
        return true;
    }

    public String extractScope(ShowPrivilegeScope scope) {
        String string;
        ShowPrivilegeScope showPrivilegeScope = scope;
        if (showPrivilegeScope instanceof ShowUserPrivileges) {
            ShowUserPrivileges showUserPrivileges = (ShowUserPrivileges)showPrivilegeScope;
            Option<Either<String, Parameter>> name = showUserPrivileges.user();
            string = name.isDefined() ? new StringBuilder(5).append("USER ").append(this.escapeName((Either<String, Parameter>)((Either)name.get()))).toString() : "USER";
        } else if (showPrivilegeScope instanceof ShowRolePrivileges) {
            ShowRolePrivileges showRolePrivileges = (ShowRolePrivileges)showPrivilegeScope;
            Either<String, Parameter> name = showRolePrivileges.role();
            string = new StringBuilder(5).append("ROLE ").append(this.escapeName(name)).toString();
        } else {
            string = showPrivilegeScope instanceof ShowAllPrivileges ? "ALL" : "<unknown>";
        }
        return string;
    }

    public String extractGraphScope(List<GraphScope> dbScope) {
        Tuple3<String, Object, Object> tuple3 = this.extractDbScope(dbScope);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String dbString = (String)tuple3._1();
        boolean multipleDbs = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple2 tuple2 = new Tuple2((Object)dbString, (Object)BoxesRunTime.boxToBoolean((boolean)multipleDbs));
        Tuple2 tuple22 = tuple2;
        String dbString2 = (String)tuple22._1();
        boolean multipleDbs2 = tuple22._2$mcZ$sp();
        String graphWord = multipleDbs2 ? "GRAPHS" : "GRAPH";
        return new StringBuilder(1).append(graphWord).append(" ").append(dbString2).toString();
    }

    public String extractScope(List<GraphScope> dbScope, PrivilegeQualifier qualifier) {
        return new StringBuilder(0).append(this.extractGraphScope(dbScope)).append(this.extractQualifierString(qualifier)).toString();
    }

    public String extractLabelScope(List<GraphScope> dbScope, ActionResource resource) {
        String string;
        ActionResource actionResource = resource;
        if (actionResource instanceof LabelsResource) {
            LabelsResource labelsResource = (LabelsResource)actionResource;
            Seq<String> names = labelsResource.labels();
            string = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$27 -> ExpressionStringifier$.MODULE$.backtick((String)x$27, ExpressionStringifier$.MODULE$.backtick$default$2()), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        } else if (actionResource instanceof AllLabelResource) {
            string = "*";
        } else {
            throw new MatchError((Object)actionResource);
        }
        String labelNames = string;
        Tuple3<String, Object, Object> tuple3 = this.extractDbScope(dbScope);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String dbString = (String)tuple3._1();
        boolean multipleDbs = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple2 tuple2 = new Tuple2((Object)dbString, (Object)BoxesRunTime.boxToBoolean((boolean)multipleDbs));
        Tuple2 tuple22 = tuple2;
        String dbString2 = (String)tuple22._1();
        boolean multipleDbs2 = tuple22._2$mcZ$sp();
        String graphWord = multipleDbs2 ? "GRAPHS" : "GRAPH";
        return new StringBuilder(5).append(labelNames).append(" ON ").append(graphWord).append(" ").append(dbString2).toString();
    }

    public Tuple2<String, String> extractScope(ActionResource resource, List<GraphScope> dbScope, PrivilegeQualifier qualifier) {
        String string;
        ActionResource actionResource = resource;
        if (actionResource instanceof PropertyResource) {
            PropertyResource propertyResource = (PropertyResource)actionResource;
            String name = propertyResource.property();
            string = ExpressionStringifier$.MODULE$.backtick(name, ExpressionStringifier$.MODULE$.backtick$default$2());
        } else if (actionResource instanceof PropertiesResource) {
            PropertiesResource propertiesResource = (PropertiesResource)actionResource;
            Seq<String> names = propertiesResource.properties();
            string = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$29 -> ExpressionStringifier$.MODULE$.backtick((String)x$29, ExpressionStringifier$.MODULE$.backtick$default$2()), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        } else {
            string = actionResource instanceof AllPropertyResource ? "*" : "<unknown>";
        }
        String resourceName = string;
        return new Tuple2((Object)resourceName, (Object)this.extractScope(dbScope, qualifier));
    }

    public String revokeOperation(String operation, String revokeType) {
        return new StringBuilder(2).append(operation).append("(").append(revokeType).append(")").toString();
    }

    public String prettifyDatabasePrivilege(String privilegeName, List<GraphScope> dbScope, PrivilegeQualifier qualifier, String preposition, Seq<Either<String, Parameter>> roleNames) {
        Tuple3<String, Object, Object> tuple3 = this.extractDbScope(dbScope);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String dbName = (String)tuple3._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean multiple = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)dbName, (Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)BoxesRunTime.boxToBoolean((boolean)multiple));
        Tuple3 tuple33 = tuple32;
        String dbName2 = (String)tuple33._1();
        default = BoxesRunTime.unboxToBoolean((Object)tuple33._2());
        boolean multiple2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
        String db = default ? "DEFAULT DATABASE" : (multiple2 ? new StringBuilder(10).append("DATABASES ").append(dbName2).toString() : new StringBuilder(9).append("DATABASE ").append(dbName2).toString());
        return new StringBuilder(6).append(privilegeName).append(this.extractQualifierString(qualifier)).append(" ON ").append(db).append(" ").append(preposition).append(" ").append(this.escapeNames(roleNames)).toString();
    }

    public Option<String> extractQualifierPart(PrivilegeQualifier qualifier) {
        Object object;
        PrivilegeQualifier privilegeQualifier = qualifier;
        if (privilegeQualifier instanceof LabelQualifier) {
            LabelQualifier labelQualifier = (LabelQualifier)privilegeQualifier;
            String name2 = labelQualifier.label();
            object = new Some((Object)new StringBuilder(5).append("NODE ").append(ExpressionStringifier$.MODULE$.backtick(name2, ExpressionStringifier$.MODULE$.backtick$default$2())).toString());
        } else if (privilegeQualifier instanceof LabelsQualifier) {
            LabelsQualifier labelsQualifier = (LabelsQualifier)privilegeQualifier;
            Seq<String> names = labelsQualifier.labels();
            object = new Some((Object)new StringBuilder(6).append("NODES ").append(((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$31 -> ExpressionStringifier$.MODULE$.backtick((String)x$31, ExpressionStringifier$.MODULE$.backtick$default$2()), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        } else if (privilegeQualifier instanceof LabelAllQualifier) {
            object = new Some((Object)"NODES *");
        } else if (privilegeQualifier instanceof RelationshipQualifier) {
            RelationshipQualifier relationshipQualifier = (RelationshipQualifier)privilegeQualifier;
            String name3 = relationshipQualifier.reltype();
            object = new Some((Object)new StringBuilder(13).append("RELATIONSHIP ").append(ExpressionStringifier$.MODULE$.backtick(name3, ExpressionStringifier$.MODULE$.backtick$default$2())).toString());
        } else if (privilegeQualifier instanceof RelationshipsQualifier) {
            RelationshipsQualifier relationshipsQualifier = (RelationshipsQualifier)privilegeQualifier;
            Seq<String> names = relationshipsQualifier.reltypes();
            object = new Some((Object)new StringBuilder(14).append("RELATIONSHIPS ").append(((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$32 -> ExpressionStringifier$.MODULE$.backtick((String)x$32, ExpressionStringifier$.MODULE$.backtick$default$2()), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        } else if (privilegeQualifier instanceof RelationshipAllQualifier) {
            object = new Some((Object)"RELATIONSHIPS *");
        } else if (privilegeQualifier instanceof ElementsQualifier) {
            ElementsQualifier elementsQualifier = (ElementsQualifier)privilegeQualifier;
            Seq<String> names = elementsQualifier.values();
            object = new Some((Object)new StringBuilder(9).append("ELEMENTS ").append(((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$33 -> ExpressionStringifier$.MODULE$.backtick((String)x$33, ExpressionStringifier$.MODULE$.backtick$default$2()), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        } else if (privilegeQualifier instanceof ElementsAllQualifier) {
            object = new Some((Object)"ELEMENTS *");
        } else if (privilegeQualifier instanceof UsersQualifier) {
            UsersQualifier usersQualifier = (UsersQualifier)privilegeQualifier;
            Seq<Either<String, Parameter>> names = usersQualifier.usernames();
            object = new Some((Object)new StringBuilder(2).append("(").append(((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.escapeName((Either<String, Parameter>)name), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString());
        } else if (privilegeQualifier instanceof UserQualifier) {
            UserQualifier userQualifier = (UserQualifier)privilegeQualifier;
            Either<String, Parameter> name4 = userQualifier.username();
            object = new Some((Object)new StringBuilder(2).append("(").append(this.escapeName(name4)).append(")").toString());
        } else {
            object = privilegeQualifier instanceof UserAllQualifier ? new Some((Object)"(*)") : (privilegeQualifier instanceof AllQualifier ? None$.MODULE$ : new Some((Object)"<unknown>"));
        }
        return object;
    }

    private String extractQualifierString(PrivilegeQualifier qualifier) {
        String string;
        Option<String> qualifierPart = this.extractQualifierPart(qualifier);
        Option<String> option = qualifierPart;
        if (option instanceof Some) {
            Some some = (Some)option;
            String string2 = (String)some.value();
            string = new StringBuilder(1).append(" ").append(string2).toString();
        } else {
            string = "";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple3<String, Object, Object> extractDbScope(List<GraphScope> dbScope) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<GraphScope> list = dbScope;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            GraphScope graphScope = (GraphScope)colon2.head();
            List list2 = colon2.tl$access$1();
            if (graphScope instanceof NamedGraphScope) {
                NamedGraphScope namedGraphScope = (NamedGraphScope)graphScope;
                Either<String, Parameter> name = namedGraphScope.database();
                if (Nil$.MODULE$.equals(list2)) {
                    return new Tuple3((Object)this.escapeName(name), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
            }
        }
        if (bl) {
            GraphScope graphScope = (GraphScope)colon2.head();
            List list3 = colon2.tl$access$1();
            if (graphScope instanceof AllGraphsScope && Nil$.MODULE$.equals(list3)) {
                return new Tuple3((Object)"*", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (!bl) return new Tuple3((Object)this.escapeNames((Seq<Either<String, Parameter>>)((Seq)list.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends GraphScope, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Either<String, Parameter> either;
                A1 A1 = x1;
                if (A1 instanceof NamedGraphScope) {
                    Either<String, Parameter> name;
                    NamedGraphScope namedGraphScope = (NamedGraphScope)A1;
                    either = name = namedGraphScope.database();
                } else {
                    either = function1.apply(x1);
                }
                return (B1)either;
            }

            public final boolean isDefinedAt(GraphScope x1) {
                GraphScope graphScope = x1;
                boolean bl = graphScope instanceof NamedGraphScope;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom()))), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        GraphScope graphScope = (GraphScope)colon2.head();
        List list4 = colon2.tl$access$1();
        if (!(graphScope instanceof DefaultDatabaseScope)) return new Tuple3((Object)this.escapeNames((Seq<Either<String, Parameter>>)((Seq)list.collect((PartialFunction)new /* invalid duplicate definition of identical inner class */, List$.MODULE$.canBuildFrom()))), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!Nil$.MODULE$.equals(list4)) return new Tuple3((Object)this.escapeNames((Seq<Either<String, Parameter>>)((Seq)list.collect((PartialFunction)new /* invalid duplicate definition of identical inner class */, List$.MODULE$.canBuildFrom()))), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        return new Tuple3((Object)"DEFAULT", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public String escapeName(Either<String, Parameter> name) {
        String string;
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String s = (String)left.value();
            string = ExpressionStringifier$.MODULE$.backtick(s, ExpressionStringifier$.MODULE$.backtick$default$2());
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            string = new StringBuilder(1).append("$").append(ExpressionStringifier$.MODULE$.backtick(p.name(), ExpressionStringifier$.MODULE$.backtick$default$2())).toString();
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    public String escapeNames(Seq<Either<String, Parameter>> names) {
        return ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.escapeName((Either<String, Parameter>)name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public Prettifier apply(ExpressionStringifier expr, Prettifier.ClausePrettifier extension, boolean useInCommands) {
        return new Prettifier(expr, extension, useInCommands);
    }

    public Prettifier.ClausePrettifier apply$default$2() {
        return Prettifier$EmptyExtension$.MODULE$;
    }

    public boolean apply$default$3() {
        return true;
    }

    public Option<Tuple3<ExpressionStringifier, Prettifier.ClausePrettifier, Object>> unapply(Prettifier x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.expr(), (Object)x$0.extension(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useInCommands())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Prettifier$() {
        MODULE$ = this;
    }
}

