/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.semantics;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CypherTypeName;
import org.neo4j.cypher.internal.ast.FullSubqueryExpression;
import org.neo4j.cypher.internal.ast.semantics.Scope;
import org.neo4j.cypher.internal.ast.semantics.SemanticAnalysisTooling;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheck;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheck$;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckable;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.ast.semantics.SemanticExpressionCheck;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature$VectorType$;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.Symbol;
import org.neo4j.cypher.internal.expressions.DoubleLiteral;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.StringDecimalInteger;
import org.neo4j.cypher.internal.expressions.TypeSignature;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.AnyType;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.PropertyValueCypher5Type;
import org.neo4j.cypher.internal.util.symbols.PropertyValueType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.TypeSpec;
import org.neo4j.cypher.internal.util.symbols.VectorType;
import org.neo4j.cypher.internal.util.symbols.ZonedDateTimeType;
import org.neo4j.cypher.internal.util.symbols.ZonedTimeType;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class CypherTypeChecking$
implements SemanticAnalysisTooling {
    public static final CypherTypeChecking$ MODULE$ = new CypherTypeChecking$();
    private static final List<CypherType> allowedPropertyTypes;
    private static final List<CypherType> allowedPropertyTypesInGraphType;

    static {
        SemanticAnalysisTooling.$init$(MODULE$);
        allowedPropertyTypes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CypherType[]{new BooleanType(true, InputPosition$.MODULE$.NONE()), new StringType(true, InputPosition$.MODULE$.NONE()), new IntegerType(true, InputPosition$.MODULE$.NONE()), new FloatType(true, InputPosition$.MODULE$.NONE()), new DateType(true, InputPosition$.MODULE$.NONE()), new LocalTimeType(true, InputPosition$.MODULE$.NONE()), new ZonedTimeType(true, InputPosition$.MODULE$.NONE()), new LocalDateTimeType(true, InputPosition$.MODULE$.NONE()), new ZonedDateTimeType(true, InputPosition$.MODULE$.NONE()), new DurationType(true, InputPosition$.MODULE$.NONE()), new PointType(true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new BooleanType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new StringType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new IntegerType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new FloatType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new DateType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new LocalTimeType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new ZonedTimeType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new LocalDateTimeType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new ZonedDateTimeType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new DurationType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new PointType(false, InputPosition$.MODULE$.NONE()), true, InputPosition$.MODULE$.NONE())}));
        allowedPropertyTypesInGraphType = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CypherType[]{new AnyType(false, InputPosition$.MODULE$.NONE()), new BooleanType(false, InputPosition$.MODULE$.NONE()), new StringType(false, InputPosition$.MODULE$.NONE()), new IntegerType(false, InputPosition$.MODULE$.NONE()), new FloatType(false, InputPosition$.MODULE$.NONE()), new DateType(false, InputPosition$.MODULE$.NONE()), new LocalTimeType(false, InputPosition$.MODULE$.NONE()), new ZonedTimeType(false, InputPosition$.MODULE$.NONE()), new LocalDateTimeType(false, InputPosition$.MODULE$.NONE()), new ZonedDateTimeType(false, InputPosition$.MODULE$.NONE()), new DurationType(false, InputPosition$.MODULE$.NONE()), new PointType(false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new BooleanType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new StringType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new IntegerType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new FloatType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new DateType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new LocalTimeType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new ZonedTimeType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new LocalDateTimeType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new ZonedDateTimeType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new DurationType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE()), new ListType((CypherType)new PointType(false, InputPosition$.MODULE$.NONE()), false, InputPosition$.MODULE$.NONE())}))).$plus$plus(MODULE$.allowedPropertyTypes());
    }

    @Override
    public <A> SemanticCheck semanticCheckFold(Iterable<A> iterable, Function1<A, SemanticCheck> f) {
        return SemanticAnalysisTooling.semanticCheckFold$(this, iterable, f);
    }

    @Override
    public <A extends SemanticCheckable> SemanticCheck semanticCheck(IterableOnce<A> iterable) {
        return SemanticAnalysisTooling.semanticCheck$(this, iterable);
    }

    @Override
    public SemanticCheck withState(SemanticState state, SemanticCheck check2) {
        return SemanticAnalysisTooling.withState$(this, state, check2);
    }

    @Override
    public SemanticState updateRecordedGraphs(SemanticState originalState, SemanticState newState) {
        return SemanticAnalysisTooling.updateRecordedGraphs$(this, originalState, newState);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> specifyType(Function1<SemanticState, TypeSpec> typeGen, Expression expression) {
        return SemanticAnalysisTooling.specifyType$((SemanticAnalysisTooling)this, typeGen, expression);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> specifyType(Function0<TypeSpec> possibleTypes, Expression expression) {
        return SemanticAnalysisTooling.specifyType$((SemanticAnalysisTooling)this, possibleTypes, expression);
    }

    @Override
    public SemanticCheck expectType(Function1<SemanticState, TypeSpec> typeGen, Expression expression) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, typeGen, expression);
    }

    @Override
    public SemanticCheck expectType(TypeSpec possibleTypes, Option<Expression> opt) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, opt);
    }

    @Override
    public SemanticCheck expectType(Function1<SemanticState, TypeSpec> typeGen, Expression expression, SemanticExpressionCheck.TypeMismatchContext.TypeMismatchContextVal typeMismatch, Function2<String, String, String> messageGen) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, typeGen, expression, typeMismatch, messageGen);
    }

    @Override
    public <Exp extends Expression> SemanticCheck expectType(TypeSpec possibleTypes, Iterable<Exp> expressions) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expressions);
    }

    @Override
    public <Exp extends Expression> SemanticCheck expectType(TypeSpec possibleTypes, Iterable<Exp> expressions, SemanticExpressionCheck.TypeMismatchContext.TypeMismatchContextVal typeMismatchContext) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expressions, typeMismatchContext);
    }

    @Override
    public SemanticCheck expectType(Function0<TypeSpec> possibleTypes, Expression.SemanticContext ctx, Expression expr) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, ctx, expr);
    }

    @Override
    public SemanticCheck expectType(Function0<TypeSpec> possibleTypes, Expression expression) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expression);
    }

    @Override
    public SemanticCheck expectType(Function0<TypeSpec> possibleTypes, Expression expression, SemanticExpressionCheck.TypeMismatchContext.TypeMismatchContextVal typeMismatchVal, Function2<String, String, String> messageGen) {
        return SemanticAnalysisTooling.expectType$((SemanticAnalysisTooling)this, possibleTypes, expression, typeMismatchVal, messageGen);
    }

    @Override
    public SemanticCheckResult expectType(SemanticState s, Function0<TypeSpec> possibleTypes, Expression expression, SemanticExpressionCheck.TypeMismatchContext.TypeMismatchContextVal typeMismatchVal, Function2<String, String, String> messageGen) {
        return SemanticAnalysisTooling.expectType$(this, s, possibleTypes, expression, typeMismatchVal, messageGen);
    }

    @Override
    public Function2<String, String, String> expectType$default$5() {
        return SemanticAnalysisTooling.expectType$default$5$(this);
    }

    @Override
    public SemanticCheck checkTypes(Expression expression, Seq<TypeSignature> signatures) {
        return SemanticAnalysisTooling.checkTypes$(this, expression, signatures);
    }

    @Override
    public SemanticCheck whenState(Function1<SemanticState, Object> condition, Function0<SemanticCheck> thenBranch, Function0<SemanticCheck> elseBranch) {
        return SemanticAnalysisTooling.whenState$(this, condition, thenBranch, elseBranch);
    }

    @Override
    public SemanticCheck whenState$default$3(Function1<SemanticState, Object> condition) {
        return SemanticAnalysisTooling.whenState$default$3$(this, condition);
    }

    @Override
    public SemanticCheck unless(boolean condition, Function0<SemanticCheck> check2) {
        return SemanticAnalysisTooling.unless$(this, condition, check2);
    }

    @Override
    public Function1<SemanticState, TypeSpec> unionOfTypes(IterableOnce<Expression> iterable) {
        return SemanticAnalysisTooling.unionOfTypes$(this, iterable);
    }

    @Override
    public Function1<SemanticState, TypeSpec> leastUpperBoundsOfTypes(IterableOnce<Expression> iterable) {
        return SemanticAnalysisTooling.leastUpperBoundsOfTypes$(this, iterable);
    }

    @Override
    public SemanticCheck withScopedState(Function0<SemanticCheck> check2) {
        return SemanticAnalysisTooling.withScopedState$(this, check2);
    }

    @Override
    public SemanticCheck withScopedStateWithVariablesFromRecordedScope(ASTNode astNode, Set<String> exclude, Function0<SemanticCheck> check2) {
        return SemanticAnalysisTooling.withScopedStateWithVariablesFromRecordedScope$(this, astNode, exclude, check2);
    }

    @Override
    public Set<String> withScopedStateWithVariablesFromRecordedScope$default$2() {
        return SemanticAnalysisTooling.withScopedStateWithVariablesFromRecordedScope$default$2$(this);
    }

    @Override
    public SemanticCheck typeSwitch(Expression expr, Function1<TypeSpec, SemanticCheck> choice) {
        return SemanticAnalysisTooling.typeSwitch$(this, expr, choice);
    }

    @Override
    public SemanticCheck typeSwitchWithState(Expression expr, Function2<SemanticState, TypeSpec, SemanticCheck> choice) {
        return SemanticAnalysisTooling.typeSwitchWithState$(this, expr, choice);
    }

    @Override
    public boolean validNumber(StringDecimalInteger stringDecimalInteger) {
        return SemanticAnalysisTooling.validNumber$((SemanticAnalysisTooling)this, stringDecimalInteger);
    }

    @Override
    public boolean validNumber(IntegerLiteral integerLiteral) {
        return SemanticAnalysisTooling.validNumber$((SemanticAnalysisTooling)this, integerLiteral);
    }

    @Override
    public boolean validNumber(DoubleLiteral doubleLiteral) {
        return SemanticAnalysisTooling.validNumber$((SemanticAnalysisTooling)this, doubleLiteral);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> ensureDefined(LogicalVariable v) {
        return SemanticAnalysisTooling.ensureDefined$(this, v);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> declareVariable(LogicalVariable v, TypeSpec possibleTypes) {
        return SemanticAnalysisTooling.declareVariable$(this, v, possibleTypes);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> declareVariable(LogicalVariable v, TypeSpec possibleTypes, Option<Symbol> maybePreviousDeclaration) {
        return SemanticAnalysisTooling.declareVariable$(this, v, possibleTypes, maybePreviousDeclaration);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> declareVariable(LogicalVariable v, Function1<SemanticState, TypeSpec> typeGen, Option<Symbol> maybePreviousDeclaration, boolean overriding) {
        return SemanticAnalysisTooling.declareVariable$(this, v, typeGen, maybePreviousDeclaration, overriding);
    }

    @Override
    public Option<Symbol> declareVariable$default$3() {
        return SemanticAnalysisTooling.declareVariable$default$3$(this);
    }

    @Override
    public boolean declareVariable$default$4() {
        return SemanticAnalysisTooling.declareVariable$default$4$(this);
    }

    @Override
    public Function1<SemanticState, Either<SemanticError, SemanticState>> implicitVariable(LogicalVariable v, CypherType possibleType) {
        return SemanticAnalysisTooling.implicitVariable$(this, v, possibleType);
    }

    @Override
    public SemanticCheck declareVariables(Iterable<Symbol> symbols) {
        return SemanticAnalysisTooling.declareVariables$(this, symbols);
    }

    @Override
    public SemanticCheck recordCurrentScope(ASTNode astNode) {
        return SemanticAnalysisTooling.recordCurrentScope$(this, astNode);
    }

    @Override
    public SemanticCheck importValuesFromRecordedScope(ASTNode astNode) {
        return SemanticAnalysisTooling.importValuesFromRecordedScope$(this, astNode);
    }

    @Override
    public SemanticCheck importValuesFromParentInSubqueryExpression(FullSubqueryExpression subExpr) {
        return SemanticAnalysisTooling.importValuesFromParentInSubqueryExpression$(this, subExpr);
    }

    @Override
    public SemanticCheck importValuesFromScope(Scope scope) {
        return SemanticAnalysisTooling.importValuesFromScope$(this, scope);
    }

    @Override
    public SemanticCheck requireFeatureSupport(String msg, SemanticFeature feature, InputPosition position) {
        return SemanticAnalysisTooling.requireFeatureSupport$(this, msg, feature, position);
    }

    @Override
    public SemanticCheck error(String msg, InputPosition position) {
        return SemanticAnalysisTooling.error$(this, msg, position);
    }

    @Override
    public SemanticCheck error(ErrorGqlStatusObject gqlStatusObject, String msg, InputPosition position) {
        return SemanticAnalysisTooling.error$(this, gqlStatusObject, msg, position);
    }

    @Override
    public SemanticCheck error(SemanticError semanticError) {
        return SemanticAnalysisTooling.error$(this, semanticError);
    }

    @Override
    public SemanticCheck warn(InternalNotification notification) {
        return SemanticAnalysisTooling.warn$(this, notification);
    }

    @Override
    public Function1<SemanticState, TypeSpec> possibleTypes(Expression expression) {
        return SemanticAnalysisTooling.possibleTypes$(this, expression);
    }

    @Override
    public Function1<SemanticState, TypeSpec> types(Expression expression) {
        return SemanticAnalysisTooling.types$(this, expression);
    }

    private List<CypherType> allowedPropertyTypes() {
        return allowedPropertyTypes;
    }

    private List<CypherType> allowedPropertyTypesInGraphType() {
        return allowedPropertyTypesInGraphType;
    }

    private SemanticCheck checkVectorFeatureFlag(CypherType propertyType) {
        Some maybeVector;
        ListType listType;
        CypherType v2;
        CypherType cypherType = propertyType;
        if (cypherType instanceof VectorType) {
            VectorType vectorType = (VectorType)cypherType;
            v0 = new Some((Object)vectorType);
        } else if (cypherType instanceof ListType && (v2 = (listType = (ListType)cypherType).innerType()) instanceof VectorType) {
            VectorType vectorType = (VectorType)v2;
            v0 = new Some((Object)vectorType);
        } else if (cypherType instanceof ClosedDynamicUnionType) {
            ClosedDynamicUnionType closedDynamicUnionType = (ClosedDynamicUnionType)cypherType;
            v0 = closedDynamicUnionType.sortedInnerTypes().find((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CypherTypeChecking$.$anonfun$checkVectorFeatureFlag$1(v)));
        } else {
            v0 = maybeVector = None$.MODULE$;
        }
        if (maybeVector.isDefined()) {
            return this.requireFeatureSupport("Property type constraints for vectors", SemanticFeature$VectorType$.MODULE$, ((ASTNode)maybeVector.get()).position());
        }
        return SemanticCheck$.MODULE$.success();
    }

    public SemanticCheck checkPropertyTypeForConstraint(CypherType originalPropertyType, CypherType normalizedPropertyType, Function3<CypherType, String, Option<ErrorGqlStatusObject>, SemanticError> errorFn) {
        return this.checkPropertyTypes(originalPropertyType, normalizedPropertyType, errorFn, this.allowedPropertyTypes());
    }

    public SemanticCheck checkPropertyTypeForGraphType(CypherType originalPropertyType, CypherType normalizedPropertyType, Function3<CypherType, String, Option<ErrorGqlStatusObject>, SemanticError> errorFn) {
        return this.checkPropertyTypes(originalPropertyType, normalizedPropertyType, errorFn, this.allowedPropertyTypesInGraphType());
    }

    private SemanticCheck checkPropertyTypes(CypherType originalPropertyType, CypherType normalizedPropertyType, Function3<CypherType, String, Option<ErrorGqlStatusObject>, SemanticError> errorFn, List<CypherType> allowedTypes) {
        return this.checkVectorFeatureFlag(normalizedPropertyType).chain(new CypherTypeName(originalPropertyType).semanticCheck().map((Function1<SemanticCheckResult, SemanticCheckResult>)(Function1 & Serializable)x0$1 -> {
            Seq<SemanticErrorDef> seq;
            SemanticCheckResult semanticCheckResult = x0$1;
            if (semanticCheckResult != null && Nil$.MODULE$.equals(seq = semanticCheckResult.errors())) {
                return semanticCheckResult;
            }
            if (semanticCheckResult != null) {
                SemanticState state = semanticCheckResult.state();
                return new SemanticCheckResult(state, (Seq<SemanticErrorDef>)new .colon.colon((Object)((SemanticError)errorFn.apply((Object)originalPropertyType, (Object)"", (Object)None$.MODULE$)), (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)semanticCheckResult);
        })).chain(this.allowedTypesCheck$1(originalPropertyType, normalizedPropertyType, allowedTypes, errorFn));
    }

    private boolean checkVectorAllowed(VectorType vectorType) {
        VectorType vectorType2 = vectorType;
        if (vectorType2 != null) {
            Option option = vectorType2.innerType();
            Option option2 = vectorType2.dimension();
            boolean bl = vectorType2.isNullable();
            if (option instanceof Some && option2 instanceof Some) {
                Some some = (Some)option2;
                long dim = BoxesRunTime.unboxToLong((Object)some.value());
                if (bl) {
                    return dim >= 1L && dim <= 4096L;
                }
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkVectorFeatureFlag$1(CypherType v) {
        return v instanceof VectorType;
    }

    private final boolean anyPropertyValueType$1(CypherType pt2) {
        CypherType cypherType;
        while (true) {
            if ((cypherType = pt2) instanceof PropertyValueType) {
                return true;
            }
            if (cypherType instanceof PropertyValueCypher5Type) {
                return true;
            }
            if (!(cypherType instanceof ListType)) break;
            ListType listType = (ListType)cypherType;
            pt2 = listType.innerType();
        }
        if (cypherType instanceof ClosedDynamicUnionType) {
            ClosedDynamicUnionType closedDynamicUnionType = (ClosedDynamicUnionType)cypherType;
            return closedDynamicUnionType.sortedInnerTypes().map((Function1 & Serializable)pt -> BoxesRunTime.boxToBoolean((boolean)this.anyPropertyValueType$1(pt))).exists((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkPropertyTypes$3(List allowedTypes$1, CypherType p) {
        return allowedTypes$1.contains((Object)p.withPosition(InputPosition$.MODULE$.NONE())) || p instanceof VectorType && MODULE$.checkVectorAllowed((VectorType)p);
    }

    public static final /* synthetic */ boolean $anonfun$checkPropertyTypes$4(CypherType inner) {
        return inner instanceof ListType || inner instanceof VectorType;
    }

    public static final /* synthetic */ boolean $anonfun$checkPropertyTypes$5(CypherType inner) {
        return inner instanceof ListType || inner instanceof VectorType;
    }

    private static final Tuple2 additionalErrorInfo$1(CypherType pt2) {
        ClosedDynamicUnionType closedDynamicUnionType;
        Some some;
        long dim;
        Option option;
        CypherType inner2;
        boolean bl = false;
        ListType listType = null;
        boolean bl2 = false;
        VectorType vectorType = null;
        CypherType cypherType = pt2;
        if (cypherType instanceof ListType) {
            bl = true;
            listType = (ListType)cypherType;
            if (listType.innerType() instanceof ListType) {
                return new Tuple2((Object)" Lists cannot have lists as an inner type.", (Object)new Some((Object)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB9).withParam(GqlParams.StringParam.typeDescription, "a list").build()));
            }
        }
        if (bl && listType.innerType() instanceof ClosedDynamicUnionType) {
            return new Tuple2((Object)" Lists cannot have a union of types as an inner type.", (Object)new Some((Object)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB9).withParam(GqlParams.StringParam.typeDescription, "a union of types").build()));
        }
        if (bl && listType.innerType() instanceof VectorType) {
            return new Tuple2((Object)" Lists cannot have a vector as an inner type.", (Object)new Some((Object)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB9).withParam(GqlParams.StringParam.typeDescription, "a vector").build()));
        }
        if (bl && (inner2 = listType.innerType()).isNullable()) {
            return new Tuple2((Object)" Lists cannot have nullable inner types.", (Object)new Some((Object)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB9).withParam(GqlParams.StringParam.typeDescription, "a nullable type").build()));
        }
        if (cypherType instanceof VectorType) {
            bl2 = true;
            vectorType = (VectorType)cypherType;
            Option inner3 = vectorType.innerType();
            Option dim2 = vectorType.dimension();
            if (inner3.isEmpty() || dim2.isEmpty()) {
                return new Tuple2((Object)" Property type constraints for vectors need to define both coordinate type and dimension.", (Object)new Some((Object)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NBA).build()));
            }
        }
        if (bl2 && (option = vectorType.dimension()) instanceof Some && ((dim = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) < 1L || dim > 4096L)) {
            return new Tuple2((Object)(" The dimension of property type constraints for vectors needs to be between " + 1 + " and " + 4096 + "."), (Object)new Some((Object)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N31).withParam(GqlParams.StringParam.component, "DIMENSION").withParam(GqlParams.StringParam.valueType, "INTEGER NOT NULL").withParam(GqlParams.NumberParam.lower, (Number)Predef$.MODULE$.int2Integer(1)).withParam(GqlParams.NumberParam.upper, (Number)Predef$.MODULE$.int2Integer(4096)).withParam(GqlParams.StringParam.value, Long.toString(dim)).build()));
        }
        if (cypherType instanceof ClosedDynamicUnionType && (closedDynamicUnionType = (ClosedDynamicUnionType)cypherType).sortedInnerTypes().exists((Function1 & Serializable)inner -> BoxesRunTime.boxToBoolean((boolean)CypherTypeChecking$.$anonfun$checkPropertyTypes$4(inner)))) {
            return (Tuple2)closedDynamicUnionType.sortedInnerTypes().filter((Function1 & Serializable)inner -> BoxesRunTime.boxToBoolean((boolean)CypherTypeChecking$.$anonfun$checkPropertyTypes$5(inner))).map((Function1 & Serializable)pt -> CypherTypeChecking$.additionalErrorInfo$1(pt)).find((Function1 & Serializable)inner -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)inner._1())))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)"", (Object)None$.MODULE$));
        }
        return new Tuple2((Object)"", (Object)None$.MODULE$);
    }

    private final SemanticCheck allowedTypesCheck$1(CypherType originalPropertyType$1, CypherType normalizedPropertyType$1, List allowedTypes$1, Function3 errorFn$1) {
        boolean onlyAllowedTypes;
        boolean containsPropertyValueType = this.anyPropertyValueType$1(originalPropertyType$1);
        CypherType cypherType = normalizedPropertyType$1;
        if (cypherType instanceof VectorType) {
            VectorType vectorType = (VectorType)cypherType;
            v0 = this.checkVectorAllowed(vectorType);
        } else if (cypherType instanceof ClosedDynamicUnionType) {
            ClosedDynamicUnionType closedDynamicUnionType = (ClosedDynamicUnionType)cypherType;
            v0 = closedDynamicUnionType.sortedInnerTypes().forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)CypherTypeChecking$.$anonfun$checkPropertyTypes$3(allowedTypes$1, p)));
        } else {
            v0 = onlyAllowedTypes = allowedTypes$1.contains((Object)normalizedPropertyType$1.withPosition(InputPosition$.MODULE$.NONE()));
        }
        if (containsPropertyValueType || !onlyAllowedTypes) {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = containsPropertyValueType ? new Tuple2((Object)originalPropertyType$1, (Object)CypherTypeChecking$.additionalErrorInfo$1(originalPropertyType$1)) : new Tuple2((Object)normalizedPropertyType$1, (Object)CypherTypeChecking$.additionalErrorInfo$1(normalizedPropertyType$1));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CypherType propertyType = (CypherType)tuple2._1();
            Tuple2 additionalError = (Tuple2)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)propertyType, (Object)additionalError);
            CypherType propertyType2 = (CypherType)tuple23._1();
            Tuple2 additionalError2 = (Tuple2)tuple23._2();
            return this.error((SemanticError)errorFn$1.apply((Object)propertyType2, additionalError2._1(), additionalError2._2()));
        }
        return SemanticCheck$.MODULE$.success();
    }

    private CypherTypeChecking$() {
    }
}

