/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.log4j.Neo4jLogMessage;

public class AssertableLogProvider
extends AbstractLogProvider<Log> {
    private final boolean debugEnabled;
    private final Queue<LogCall> logCalls = new LinkedBlockingQueue<LogCall>();

    public AssertableLogProvider() {
        this(false);
    }

    public AssertableLogProvider(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void print(PrintStream out) {
        for (LogCall call : this.logCalls) {
            out.println(call.toLogLikeString());
            if (call.throwable == null) continue;
            call.throwable.printStackTrace(out);
        }
    }

    Queue<LogCall> getLogCalls() {
        return this.logCalls;
    }

    protected Log buildLog(Class<?> loggingClass) {
        return new AssertableLog(loggingClass.getName());
    }

    protected Log buildLog(String context) {
        return new AssertableLog(context);
    }

    public void clear() {
        this.logCalls.clear();
    }

    public String serialize() {
        return AssertableLogProvider.serialize0(this.logCalls.iterator(), LogCall::toLogLikeString);
    }

    private static String serialize0(Iterator<LogCall> events, Function<LogCall, String> serializer) {
        StringBuilder sb = new StringBuilder();
        while (events.hasNext()) {
            sb.append(serializer.apply(events.next()));
            sb.append('\n');
        }
        return sb.toString();
    }

    protected class AssertableLog
    extends AbstractLog {
        private final String context;

        AssertableLog(String context) {
            this.context = context;
        }

        public boolean isDebugEnabled() {
            return AssertableLogProvider.this.debugEnabled;
        }

        public void debug(String message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.DEBUG, message, null, null));
        }

        public void debug(String message, Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.DEBUG, message, null, throwable));
        }

        public void debug(String format, Object ... arguments) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.DEBUG, format, arguments, null));
        }

        public void info(String message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.INFO, message, null, null));
        }

        public void info(String message, Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.INFO, message, null, throwable));
        }

        public void info(String format, Object ... arguments) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.INFO, format, arguments, null));
        }

        public void warn(String message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.WARN, message, null, null));
        }

        public void warn(String message, Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.WARN, message, null, throwable));
        }

        public void warn(String format, Object ... arguments) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.WARN, format, arguments, null));
        }

        public void error(String message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.ERROR, message, null, null));
        }

        public void error(String message, Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.ERROR, message, null, throwable));
        }

        public void error(String format, Object ... arguments) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.ERROR, format, arguments, null));
        }

        public void debug(Neo4jLogMessage message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.DEBUG, message.getFormattedMessage(), null, null));
        }

        public void info(Neo4jLogMessage message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.INFO, message.getFormattedMessage(), null, null));
        }

        public void warn(Neo4jLogMessage message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.WARN, message.getFormattedMessage(), null, null));
        }

        public void error(Neo4jLogMessage message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.ERROR, message.getFormattedMessage(), null, null));
        }

        public void error(Neo4jLogMessage message, Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, Level.ERROR, message.getFormattedMessage(), null, throwable));
        }

        public void bulk(Consumer<Log> consumer) {
            consumer.accept((Log)this);
        }
    }

    static final class LogCall {
        private final String context;
        private final Level level;
        private final String message;
        private final Object[] arguments;
        private final Throwable throwable;

        private LogCall(String context, Level level, String message, Object[] arguments, Throwable throwable) {
            this.level = level;
            this.context = context;
            this.message = message;
            this.arguments = arguments;
            this.throwable = throwable;
        }

        String getContext() {
            return this.context;
        }

        Level getLevel() {
            return this.level;
        }

        String getMessage() {
            return this.message;
        }

        Object[] getArguments() {
            return this.arguments;
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LogCall{");
            builder.append(this.context);
            builder.append(' ');
            builder.append((Object)this.level);
            builder.append(", message=");
            if (this.message != null) {
                builder.append('\'').append(StringEscapeUtils.escapeJava((String)this.message)).append('\'');
            } else {
                builder.append("null");
            }
            builder.append(", arguments=");
            if (this.arguments != null) {
                builder.append('[');
                boolean first = true;
                for (Object arg : this.arguments) {
                    if (!first) {
                        builder.append(',');
                    }
                    first = false;
                    builder.append(StringEscapeUtils.escapeJava((String)String.valueOf(arg)));
                }
                builder.append(']');
            } else {
                builder.append("null");
            }
            builder.append(", throwable=");
            if (this.throwable != null) {
                builder.append('\'').append(StringEscapeUtils.escapeJava((String)this.throwable.toString())).append('\'');
            } else {
                builder.append("null");
            }
            builder.append('}');
            return builder.toString();
        }

        String toLogLikeString() {
            Object msg;
            if (this.arguments != null) {
                try {
                    msg = String.format(this.message, this.arguments);
                }
                catch (IllegalFormatException e) {
                    msg = String.format("IllegalFormat{message: \"%s\", arguments: %s}", this.message, Arrays.toString(this.arguments));
                }
            } else {
                msg = this.message;
            }
            if (this.throwable != null) {
                msg = (String)msg + " cause " + String.valueOf(this.throwable);
            }
            return String.format("%s @ %s: %s", new Object[]{this.level, this.context, msg});
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

