/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.AssertableLogProvider;

public class LogAssert
extends AbstractAssert<LogAssert, AssertableLogProvider> {
    private Class<?> loggerClazz;
    private AssertableLogProvider.Level logLevel;

    public LogAssert(AssertableLogProvider logProvider) {
        super((Object)logProvider, LogAssert.class);
    }

    public LogAssert forClass(Class<?> clazz) {
        this.loggerClazz = clazz;
        return this;
    }

    public LogAssert forLevel(AssertableLogProvider.Level level) {
        this.logLevel = level;
        return this;
    }

    public LogAssert containsMessages(String ... messages) {
        this.isNotNull();
        for (String message : messages) {
            if (this.haveMessage(message)) continue;
            this.failWithMessage("Expected log to contain messages: `%s` but no matches found in:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessagesOnce(String ... messages) {
        this.isNotNull();
        for (String message : messages) {
            long messageMatchCount = this.messageMatchCount(message);
            if (messageMatchCount == 1L) continue;
            if (messageMatchCount == 0L) {
                this.failWithMessage("Expected log to contain messages: `%s` exactly once but no matches found in:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
                continue;
            }
            this.failWithMessage("Expected log to contain messages: `%s` exactly once but %d matches found in:%n%s", new Object[]{Arrays.toString(messages), messageMatchCount, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert doesNotHaveAnyLogs() {
        this.isNotNull();
        if (((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call))) {
            this.failWithMessage("Expected log to be empty but following log calls were recorded:%n%s", new Object[]{((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert doesNotContainMessage(String message) {
        this.isNotNull();
        if (this.haveMessage(message)) {
            this.failWithMessage("Unexpected log message: `%s` in:%n%s", new Object[]{message, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithArguments(String message, Object ... arguments) {
        this.isNotNull();
        if (!this.haveMessageWithArguments(message, arguments)) {
            this.failWithMessage("Expected log to contain messages: `%s` with arguments: `%s`. But no matches found in:%n%s", new Object[]{message, Arrays.toString(arguments), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert doesNotContainMessageWithArguments(String message, Object ... arguments) {
        this.isNotNull();
        if (this.haveMessageWithArguments(message, arguments)) {
            this.failWithMessage("Unexpected log message: `%s` with arguments: `%s`  in:%n%s", new Object[]{message, Arrays.toString(arguments), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert eachMessageContains(String message) {
        this.isNotNull();
        for (AssertableLogProvider.LogCall logCall : ((AssertableLogProvider)((Object)this.actual)).getLogCalls()) {
            if (LogAssert.matchedMessage(message, logCall)) continue;
            this.failWithMessage("Expected each log message to contain '%s', but message '%s' doesn't", new Object[]{message, logCall.toLogLikeString()});
        }
        return this;
    }

    public AbstractThrowableAssert<?, ? extends Throwable> assertExceptionForLogMessage(String message) {
        this.isNotNull();
        this.haveMessage(message);
        Optional<AssertableLogProvider.LogCall> logCall = ((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().filter(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call)).findFirst();
        if (logCall.isEmpty()) {
            this.failWithMessage("Expected log call with message `%s` not found in:%n%s.", new Object[]{message, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return Assertions.assertThat((Throwable)logCall.get().getThrowable());
    }

    public LogAssert containsMessageWithException(String message, Throwable t) {
        this.isNotNull();
        Objects.requireNonNull(t);
        if (!this.haveMessageWithException(message, t)) {
            this.failWithMessage("Expected log to contain message `%s` with exception: `%s`. But no matches found in:%n%s", new Object[]{message, Exceptions.stringify((Throwable)t), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsException(Throwable t) {
        Objects.requireNonNull(t);
        this.isNotNull();
        if (((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().noneMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && t.equals(call.getThrowable()))) {
            this.failWithMessage("Expected log to contain exception: `%s`. But no matches found in:%n%s", new Object[]{Exceptions.stringify((Throwable)t), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    private boolean haveMessageWithException(String message, Throwable t) {
        return ((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && t.equals(call.getThrowable()) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessageWithArguments(String message, Object ... arguments) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && Arrays.equals(call.getArguments(), arguments) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessage(String message) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call));
    }

    private long messageMatchCount(String message) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().filter(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call)).count();
    }

    private static boolean matchedMessage(String message, AssertableLogProvider.LogCall call) {
        return call.getMessage().contains(message) || call.toLogLikeString().contains(message);
    }

    private boolean matchedLogger(AssertableLogProvider.LogCall call) {
        return this.loggerClazz == null || this.loggerClazz.getName().equals(call.getContext());
    }

    private boolean matchedLevel(AssertableLogProvider.LogCall call) {
        return this.logLevel == null || this.logLevel == call.getLevel();
    }
}

