/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Map;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class StubPropertyCursor
extends DefaultCloseListenable
implements PropertyCursor {
    private int offset = -1;
    private Integer[] keys;
    private Value[] values;
    private PropertySelection selection;

    public void init(Map<Integer, Value> properties, PropertySelection selection) {
        this.selection = selection;
        this.offset = -1;
        this.keys = properties.keySet().toArray(new Integer[0]);
        this.values = properties.values().toArray(new Value[0]);
    }

    public boolean next() {
        while (this.offset + 1 < this.keys.length) {
            if (++this.offset >= this.keys.length || !this.selection.test(this.keys[this.offset].intValue())) continue;
            return true;
        }
        return false;
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }

    public int propertyKey() {
        return this.keys[this.offset];
    }

    public ValueGroup propertyType() {
        return this.values[this.offset].valueGroup();
    }

    public Value propertyValue() {
        return this.values[this.offset];
    }

    public void setTracer(KernelReadTracer tracer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeTracer() {
        throw new UnsupportedOperationException("not implemented");
    }
}

