/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Map;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class StubPropertyCursor
extends DefaultCloseListenable
implements PropertyCursor {
    private int offset = -1;
    private Integer[] keys;
    private Value[] values;

    void init(Map<Integer, Value> properties) {
        this.offset = -1;
        this.keys = properties.keySet().toArray(new Integer[0]);
        this.values = properties.values().toArray(new Value[0]);
    }

    public boolean next() {
        return ++this.offset < this.keys.length;
    }

    public void close() {
        this.closeInternal();
        if (this.closeListener != null) {
            this.closeListener.onClosed((AutoCloseablePlus)this);
        }
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }

    public int propertyKey() {
        return this.keys[this.offset];
    }

    public ValueGroup propertyType() {
        return this.values[this.offset].valueGroup();
    }

    public Value propertyValue() {
        return this.values[this.offset];
    }

    public boolean seekProperty(int property) {
        if (property == -1) {
            return false;
        }
        while (this.next()) {
            if (property != this.propertyKey()) continue;
            return true;
        }
        return false;
    }

    public void setTracer(KernelReadTracer tracer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeTracer() {
        throw new UnsupportedOperationException("not implemented");
    }
}

