/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.NodeData;
import org.neo4j.internal.kernel.api.helpers.StubGroupCursor;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.values.storable.Value;

public class StubNodeCursor
extends DefaultCloseListenable
implements NodeCursor {
    private int offset = -1;
    private boolean dense;
    private List<NodeData> nodes = new ArrayList<NodeData>();

    public StubNodeCursor() {
        this(true);
    }

    public StubNodeCursor(boolean dense) {
        this.dense = dense;
    }

    void single(long reference) {
        this.offset = Integer.MAX_VALUE;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (reference != this.nodes.get((int)i).id) continue;
            this.offset = i - 1;
        }
    }

    void scan() {
        this.offset = -1;
    }

    public StubNodeCursor withNode(long id) {
        this.nodes.add(new NodeData(id, new long[0], Collections.emptyMap()));
        return this;
    }

    public StubNodeCursor withNode(long id, long ... labels) {
        this.nodes.add(new NodeData(id, labels, Collections.emptyMap()));
        return this;
    }

    public StubNodeCursor withNode(long id, long[] labels, Map<Integer, Value> properties) {
        this.nodes.add(new NodeData(id, labels, properties));
        return this;
    }

    public long nodeReference() {
        return this.offset >= 0 && this.offset < this.nodes.size() ? this.nodes.get((int)this.offset).id : -1L;
    }

    public LabelSet labels() {
        return this.offset >= 0 && this.offset < this.nodes.size() ? this.nodes.get(this.offset).labelSet() : LabelSet.NONE;
    }

    public LabelSet labelsIgnoringTxStateSetRemove() {
        return this.labels();
    }

    public boolean hasLabel(int label) {
        return this.labels().contains(label);
    }

    public void relationships(RelationshipGroupCursor cursor) {
        ((StubGroupCursor)cursor).rewind();
    }

    public void allRelationships(RelationshipTraversalCursor relationships) {
        ((StubRelationshipCursor)relationships).rewind();
    }

    public void properties(PropertyCursor cursor) {
        ((StubPropertyCursor)cursor).init(this.nodes.get((int)this.offset).properties);
    }

    public long relationshipGroupReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long allRelationshipsReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long propertiesReference() {
        if (this.offset >= 0 && this.offset < this.nodes.size()) {
            NodeData node = this.nodes.get(this.offset);
            if (!node.properties.isEmpty()) {
                return node.id;
            }
        }
        return -1L;
    }

    public boolean isDense() {
        return this.dense;
    }

    public void setTracer(KernelReadTracer tracer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeTracer() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (this.offset == Integer.MAX_VALUE) {
            return false;
        }
        return ++this.offset < this.nodes.size();
    }

    public void close() {
        this.closeInternal();
        if (this.closeListener != null) {
            this.closeListener.onClosed((AutoCloseablePlus)this);
        }
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }
}

