/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

public class StubCursorFactory
implements CursorFactory {
    private final boolean continueWithLastItem;
    private Queue<NodeCursor> nodeCursors = new LinkedList<NodeCursor>();
    private Queue<NodeCursor> fullNodeCursors = new LinkedList<NodeCursor>();
    private Queue<RelationshipScanCursor> relationshipScanCursors = new LinkedList<RelationshipScanCursor>();
    private Queue<RelationshipScanCursor> fullRelationshipScanCursors = new LinkedList<RelationshipScanCursor>();
    private Queue<RelationshipTraversalCursor> relationshiTraversalCursors = new LinkedList<RelationshipTraversalCursor>();
    private Queue<PropertyCursor> propertyCursors = new LinkedList<PropertyCursor>();
    private Queue<PropertyCursor> fullPropertyCursors = new LinkedList<PropertyCursor>();
    private Queue<RelationshipGroupCursor> groupCursors = new LinkedList<RelationshipGroupCursor>();
    private Queue<NodeValueIndexCursor> nodeValueIndexCursors = new LinkedList<NodeValueIndexCursor>();
    private Queue<NodeValueIndexCursor> fullNodeValueIndexCursors = new LinkedList<NodeValueIndexCursor>();
    private Queue<NodeLabelIndexCursor> nodeLabelIndexCursors = new LinkedList<NodeLabelIndexCursor>();
    private Queue<NodeLabelIndexCursor> fullNodeLabelIndexCursors = new LinkedList<NodeLabelIndexCursor>();
    private Queue<RelationshipIndexCursor> relationshipIndexCursors = new LinkedList<RelationshipIndexCursor>();

    public StubCursorFactory() {
        this(false);
    }

    public StubCursorFactory(boolean continueWithLastItem) {
        this.continueWithLastItem = continueWithLastItem;
    }

    public NodeCursor allocateNodeCursor() {
        return this.poll(this.nodeCursors);
    }

    public NodeCursor allocateFullAccessNodeCursor() {
        return this.poll(this.fullNodeCursors);
    }

    public RelationshipScanCursor allocateRelationshipScanCursor() {
        return this.poll(this.relationshipScanCursors);
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor() {
        return this.poll(this.fullRelationshipScanCursors);
    }

    public RelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        return this.poll(this.relationshiTraversalCursors);
    }

    public PropertyCursor allocatePropertyCursor() {
        return this.poll(this.propertyCursors);
    }

    public PropertyCursor allocateFullAccessPropertyCursor() {
        return this.poll(this.fullPropertyCursors);
    }

    public RelationshipGroupCursor allocateRelationshipGroupCursor() {
        return this.poll(this.groupCursors);
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor() {
        return this.poll(this.nodeValueIndexCursors);
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor() {
        return this.poll(this.nodeLabelIndexCursors);
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor() {
        return this.poll(this.relationshipIndexCursors);
    }

    public StubCursorFactory withGroupCursors(RelationshipGroupCursor ... cursors) {
        this.groupCursors.addAll(Arrays.asList(cursors));
        return this;
    }

    public StubCursorFactory withRelationshipTraversalCursors(RelationshipTraversalCursor ... cursors) {
        this.relationshiTraversalCursors.addAll(Arrays.asList(cursors));
        return this;
    }

    private <T> T poll(Queue<T> queue) {
        T poll = queue.poll();
        if (this.continueWithLastItem && queue.isEmpty()) {
            queue.offer(poll);
        }
        return poll;
    }
}

