/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.TinyLockManager;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.RecordFormat;
import org.neo4j.io.pagecache.stress.RecordStresser;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.util.concurrent.Futures;

public class PageCacheStresser {
    private final int maxPages;
    private final int numberOfThreads;
    private final ImmutableSet<OpenOption> openOptions;
    private final Path workingDirectory;

    public PageCacheStresser(int maxPages, int numberOfThreads, Path workingDirectory, ImmutableSet<OpenOption> openOptions) {
        this.maxPages = maxPages;
        this.numberOfThreads = numberOfThreads;
        this.workingDirectory = workingDirectory;
        this.openOptions = openOptions;
    }

    public void stress(PageCache pageCache, PageCacheTracer cacheTracer, Condition condition) throws Exception {
        String prefix = "pagecacheundertest";
        Path file = Files.createTempFile(this.workingDirectory, prefix, ".bin", new FileAttribute[0]);
        int reservedBytes = pageCache.pageReservedBytes(this.openOptions);
        RecordFormat format = new RecordFormat(this.numberOfThreads, pageCache.pageSize() - reservedBytes);
        int filePageSize = format.getFilePayloadSize() + reservedBytes;
        try (PagedFile pagedFile = pageCache.map(file, filePageSize, prefix, this.openOptions.newWith((Object)StandardOpenOption.DELETE_ON_CLOSE));){
            List<RecordStresser> recordStressers = this.prepare(condition, pagedFile, format, cacheTracer);
            PageCacheStresser.verifyResults(format, pagedFile, recordStressers);
            this.execute(recordStressers);
            PageCacheStresser.verifyResults(format, pagedFile, recordStressers);
        }
    }

    private List<RecordStresser> prepare(Condition condition, PagedFile pagedFile, RecordFormat format, PageCacheTracer cacheTracer) {
        int maxRecords = Math.multiplyExact(this.maxPages, format.getRecordsPerPage());
        TinyLockManager locks = new TinyLockManager();
        LinkedList<RecordStresser> recordStressers = new LinkedList<RecordStresser>();
        for (int threadId = 0; threadId < this.numberOfThreads; ++threadId) {
            recordStressers.add(new RecordStresser(pagedFile, condition, maxRecords, format, threadId, locks, cacheTracer));
        }
        return recordStressers;
    }

    private void execute(List<RecordStresser> recordStressers) throws InterruptedException, ExecutionException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        List futures = executorService.invokeAll(recordStressers);
        Futures.getAllResults(futures);
        executorService.shutdown();
        Assertions.assertTrue((boolean)executorService.awaitTermination(10L, TimeUnit.SECONDS));
    }

    private static void verifyResults(RecordFormat format, PagedFile pagedFile, List<RecordStresser> recordStressers) throws IOException {
        for (RecordStresser stresser : recordStressers) {
            stresser.verifyCounts();
        }
        try (PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
            while (cursor.next()) {
                format.verifyCheckSums(cursor);
            }
        }
    }
}

