/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import org.neo4j.adversaries.AbstractAdversary;

public final class RandomAdversary
extends AbstractAdversary {
    private final double mischiefRate;
    private final double failureRate;
    private final double errorRate;
    private volatile boolean enabled;

    public RandomAdversary(double mischiefRate, double failureRate, double errorRate) {
        assert (0.0 <= mischiefRate && mischiefRate < 1.0) : "Expected mischief rate in [0.0; 1.0[ but was " + mischiefRate;
        assert (0.0 <= failureRate && failureRate < 1.0) : "Expected failure rate in [0.0; 1.0[ but was " + failureRate;
        assert (0.0 <= errorRate && errorRate < 1.0) : "Expected error rate in [0.0; 1.0[ but was " + errorRate;
        assert (mischiefRate + errorRate + failureRate < 1.0) : "Expected mischief rate + error rate + failure rate in [0.0; 1.0[ but was " + (mischiefRate + errorRate + failureRate);
        this.mischiefRate = mischiefRate;
        this.failureRate = failureRate;
        this.errorRate = errorRate;
        this.enabled = true;
    }

    @Override
    public void injectFailure(Class<? extends Throwable> ... failureTypes) {
        this.maybeDoBadStuff(failureTypes, false);
    }

    @Override
    public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
        return this.maybeDoBadStuff(failureTypes, true);
    }

    private boolean maybeDoBadStuff(Class<? extends Throwable>[] failureTypes, boolean includingMischeif) {
        if (!this.enabled) {
            return false;
        }
        double luckyDraw = this.rng.nextDouble();
        if (luckyDraw <= this.errorRate) {
            this.throwOneOf(OutOfMemoryError.class, NullPointerException.class);
        } else if (failureTypes.length > 0 && luckyDraw <= this.failureRate + this.errorRate) {
            this.throwOneOf(failureTypes);
        }
        return includingMischeif && luckyDraw <= this.mischiefRate + this.failureRate + this.errorRate;
    }

    public void enableAdversary(boolean enabled) {
        this.enabled = enabled;
    }
}

