/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.StubPagedFile;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class StubPageCursor
extends PageCursor {
    private final long pageId;
    private final int pageSize;
    protected ByteBuffer page;
    private final int reservedBytes;
    private int currentOffset;
    private boolean observedOverflow;
    private String cursorErrorMessage;
    private boolean closed;
    private boolean needsRetry;
    protected StubPageCursor linkedCursor;
    private boolean writeLocked;
    private int mark;

    public StubPageCursor(long initialPageId, int pageSize) {
        this(initialPageId, ByteBuffers.allocate((int)pageSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE), 0);
    }

    public StubPageCursor(long initialPageId, ByteBuffer buffer) {
        this(initialPageId, buffer, 0);
    }

    public StubPageCursor(long initialPageId, ByteBuffer buffer, int reservedBytes) {
        this.pageId = initialPageId;
        this.pageSize = buffer.capacity();
        this.page = buffer;
        this.reservedBytes = reservedBytes;
        this.writeLocked = true;
        this.currentOffset = reservedBytes;
    }

    public long getCurrentPageId() {
        return this.pageId;
    }

    public Path getCurrentFile() {
        return this.getRawCurrentFile();
    }

    public PagedFile getPagedFile() {
        return new StubPagedFile(this.pageSize, this.reservedBytes);
    }

    public Path getRawCurrentFile() {
        return Path.of("", new String[0]);
    }

    public boolean next() {
        return true;
    }

    public boolean next(long pageId) {
        return true;
    }

    public void close() {
        this.closed = true;
        if (this.linkedCursor != null) {
            this.linkedCursor.close();
            this.linkedCursor = null;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean shouldRetry() {
        if (this.needsRetry) {
            this.checkAndClearBoundsFlag();
        }
        return this.needsRetry || this.linkedCursor != null && this.linkedCursor.shouldRetry();
    }

    public void setNeedsRetry(boolean needsRetry) {
        this.needsRetry = needsRetry;
    }

    public void copyPage(PageCursor targetCursor) {
        throw new UnsupportedOperationException();
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        return 0;
    }

    public int copyTo(int sourceOffset, ByteBuffer targetBuffer) {
        return 0;
    }

    public int copyFrom(ByteBuffer sourceBuffer, int targetOffset) {
        return 0;
    }

    public void shiftBytes(int sourceOffset, int length, int shift) {
        throw new UnsupportedOperationException("Stub cursor does not support this method... yet");
    }

    public boolean checkAndClearBoundsFlag() {
        boolean overflow = this.observedOverflow;
        this.observedOverflow = false;
        return overflow || this.linkedCursor != null && this.linkedCursor.checkAndClearBoundsFlag();
    }

    public void checkAndClearCursorException() throws CursorException {
        String message = this.cursorErrorMessage;
        if (message != null) {
            throw new CursorException(message);
        }
    }

    public void raiseOutOfBounds() {
        this.observedOverflow = true;
    }

    public void setCursorException(String message) {
        this.cursorErrorMessage = message;
    }

    public void clearCursorException() {
        this.cursorErrorMessage = null;
    }

    public PageCursor openLinkedCursor(long pageId) {
        this.linkedCursor = new StubPageCursor(pageId, ByteBuffers.allocate((int)this.pageSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE), this.reservedBytes);
        return this.linkedCursor;
    }

    public byte getByte() {
        byte value = this.getByteInternal(this.currentOffset);
        ++this.currentOffset;
        return value;
    }

    public byte getByte(int offset) {
        return this.getByteInternal(this.reservedBytes + offset);
    }

    private byte getByteInternal(int offset) {
        try {
            if (offset < this.reservedBytes) {
                return this.handleOverflow();
            }
            return this.page.get(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    private byte handleOverflow() {
        this.observedOverflow = true;
        return (byte)ThreadLocalRandom.current().nextInt();
    }

    public void putByte(byte value) {
        this.putByteInternal(this.currentOffset, value);
        ++this.currentOffset;
    }

    public void putByte(int offset, byte value) {
        this.putByteInternal(offset + this.reservedBytes, value);
    }

    private void putByteInternal(int offset, byte value) {
        try {
            if (offset < this.reservedBytes) {
                this.handleOverflow();
            }
            this.page.put(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public long getLong() {
        long value = this.getLongInternal(this.currentOffset);
        this.currentOffset += 8;
        return value;
    }

    public long getLong(int offset) {
        return this.getLongInternal(offset + this.reservedBytes);
    }

    private long getLongInternal(int offset) {
        try {
            if (offset < this.reservedBytes) {
                return this.handleOverflow();
            }
            return this.page.getLong(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    public void putLong(long value) {
        this.putLongInternal(this.currentOffset, value);
        this.currentOffset += 8;
    }

    public void putLong(int offset, long value) {
        this.putLongInternal(this.reservedBytes + offset, value);
    }

    private void putLongInternal(int offset, long value) {
        try {
            if (offset < this.reservedBytes) {
                this.handleOverflow();
            }
            this.page.putLong(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public int getInt() {
        int value = this.getIntInternal(this.currentOffset);
        this.currentOffset += 4;
        return value;
    }

    public int getInt(int offset) {
        return this.getIntInternal(this.reservedBytes + offset);
    }

    private int getIntInternal(int offset) {
        try {
            if (offset < this.reservedBytes) {
                return this.handleOverflow();
            }
            return this.page.getInt(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    public void putInt(int value) {
        this.putIntInternal(this.currentOffset, value);
        this.currentOffset += 4;
    }

    public void putInt(int offset, int value) {
        this.putIntInternal(this.reservedBytes + offset, value);
    }

    private void putIntInternal(int offset, int value) {
        try {
            if (offset < this.reservedBytes) {
                this.handleOverflow();
            }
            this.page.putInt(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        try {
            assert (arrayOffset == 0) : "please implement support for arrayOffset";
            this.page.position(this.currentOffset);
            this.page.get(data, arrayOffset, length);
            this.currentOffset += length;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        try {
            assert (arrayOffset == 0) : "please implement support for arrayOffset";
            this.page.position(this.currentOffset);
            this.page.put(data, arrayOffset, length);
            this.currentOffset += length;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public void putBytes(int bytes, byte value) {
        byte[] byteArray = new byte[bytes];
        Arrays.fill(byteArray, value);
        this.putBytes(byteArray, 0, bytes);
    }

    public short getShort() {
        short value = this.getShortInternal(this.currentOffset);
        this.currentOffset += 2;
        return value;
    }

    public short getShort(int offset) {
        return this.getShortInternal(this.reservedBytes + offset);
    }

    private short getShortInternal(int offset) {
        try {
            if (offset < this.reservedBytes) {
                return this.handleOverflow();
            }
            return this.page.getShort(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    public void putShort(short value) {
        this.putShortInternal(this.currentOffset, value);
        this.currentOffset += 2;
    }

    public void putShort(int offset, short value) {
        this.putShortInternal(this.reservedBytes + offset, value);
    }

    private void putShortInternal(int offset, short value) {
        try {
            if (offset < this.reservedBytes) {
                this.handleOverflow();
            }
            this.page.putShort(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public int getOffset() {
        return this.currentOffset - this.reservedBytes;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.currentOffset = offset + this.reservedBytes;
    }

    public void mark() {
        this.mark = this.currentOffset;
    }

    public void setOffsetToMark() {
        this.currentOffset = this.mark;
    }

    public void zapPage() {
        for (int i = 0; i < this.pageSize; ++i) {
            this.putByte(i, (byte)0);
        }
    }

    public String toString() {
        return "PageCursor{currentOffset=" + this.currentOffset + ", page=" + this.page + "}";
    }

    public boolean isWriteLocked() {
        return this.writeLocked;
    }

    public void unpin() {
    }

    public ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public void setWriteLocked(boolean writeLocked) {
        this.writeLocked = writeLocked;
    }
}

