/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.adversaries.AbstractAdversary;

public class CountingAdversary
extends AbstractAdversary {
    private final AtomicInteger countDown;
    private final int startingCount;
    private final boolean resetCountDownOnFailure;

    public CountingAdversary(int countDownTillFailure, boolean resetCountDownOnFailure) {
        this.startingCount = countDownTillFailure;
        this.resetCountDownOnFailure = resetCountDownOnFailure;
        this.countDown = new AtomicInteger(countDownTillFailure);
    }

    @Override
    public void injectFailure(Class<? extends Throwable> ... failureTypes) {
        int newCount;
        int count;
        while (!this.countDown.compareAndSet(count = this.countDown.get(), newCount = count - 1)) {
        }
        if (this.resetCountDownOnFailure && newCount < 1) {
            this.reset();
        }
        if (newCount == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.throwOneOf(failureTypes);
        }
    }

    @Override
    public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
        this.injectFailure(failureTypes);
        return false;
    }

    private void reset() {
        int count;
        while ((count = this.countDown.get()) < 1 && !this.countDown.compareAndSet(count, this.startingCount + count)) {
        }
    }
}

