/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.IOException;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.io.pagecache.PageCursor;

public class RecordFormat {
    private final int numberOfThreads;
    private final int cachePageSize;
    private final int fieldSize;
    private final int checksumFieldOffset;
    private final int recordSize;

    public RecordFormat(int numberOfThreads, int cachePageSize) {
        this.numberOfThreads = numberOfThreads;
        this.cachePageSize = cachePageSize;
        this.fieldSize = 8;
        this.checksumFieldOffset = numberOfThreads * this.fieldSize;
        this.recordSize = this.checksumFieldOffset + this.fieldSize;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public int getRecordsPerPage() {
        return this.cachePageSize / this.getRecordSize();
    }

    public int getFilePageSize() {
        return this.getRecordsPerPage() * this.getRecordSize();
    }

    public long incrementCounter(PageCursor cursor, int threadId) {
        int recordOffset = cursor.getOffset();
        int fieldOffset = recordOffset + this.fieldSize * threadId;
        int checksumOffset = recordOffset + this.checksumFieldOffset;
        long newValue = 1L + cursor.getLong(fieldOffset);
        cursor.putLong(fieldOffset, newValue);
        cursor.putLong(checksumOffset, 1L + cursor.getLong(checksumOffset));
        return newValue;
    }

    public long sumCountsForThread(PageCursor cursor, int threadId) throws IOException {
        long sum;
        int recordsPerPage = this.getRecordsPerPage();
        int fieldOffset = this.fieldSize * threadId;
        do {
            sum = 0L;
            for (int i = 0; i < recordsPerPage; ++i) {
                sum += cursor.getLong(i * this.recordSize + fieldOffset);
            }
        } while (cursor.shouldRetry());
        return sum;
    }

    public void verifyCheckSums(PageCursor cursor) throws IOException {
        int recordsPerPage = this.getRecordsPerPage();
        for (int i = 0; i < recordsPerPage; ++i) {
            long expectedChecksum;
            long actualChecksum;
            int recordOffset = i * this.recordSize;
            do {
                actualChecksum = 0L;
                for (int j = 0; j < this.numberOfThreads; ++j) {
                    actualChecksum += cursor.getLong(recordOffset + j * this.fieldSize);
                }
                expectedChecksum = cursor.getLong(recordOffset + this.checksumFieldOffset);
            } while (cursor.shouldRetry());
            String msg = "Checksum for record " + i + " on page " + cursor.getCurrentPageId();
            ((AbstractLongAssert)Assertions.assertThat((long)actualChecksum).describedAs(msg, new Object[0])).isEqualTo(expectedChecksum);
        }
    }
}

