/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralDynamicByteBuffer;
import org.neo4j.io.fs.EphemeralFileChannel;
import org.neo4j.io.fs.EphemeralPositionable;

class EphemeralFileData {
    private final Path file;
    private final Clock clock;
    private final Collection<WeakReference<EphemeralFileChannel>> channels = new ArrayList<WeakReference<EphemeralFileChannel>>();
    private EphemeralDynamicByteBuffer fileAsBuffer;
    private EphemeralDynamicByteBuffer forcedBuffer;
    private long lastModified;
    private int locked;

    EphemeralFileData(Path file, Clock clock) {
        this(file, new EphemeralDynamicByteBuffer(), clock);
    }

    private EphemeralFileData(Path file, EphemeralDynamicByteBuffer data, Clock clock) {
        this.file = file;
        this.fileAsBuffer = data;
        this.forcedBuffer = data.copy();
        this.clock = clock;
        this.lastModified = clock.millis();
    }

    synchronized int read(EphemeralPositionable fc, ByteBuffer dst) {
        int howMuchToReadThisTime;
        long size;
        int wanted = dst.limit() - dst.position();
        long available = Math.min((long)wanted, (size = this.fileAsBuffer.getSize()) - fc.pos());
        if (available <= 0L) {
            return -1;
        }
        byte[] scratchPad = new byte[(int)ByteUnit.kibiBytes((long)1L)];
        for (long pending = available; pending > 0L; pending -= (long)howMuchToReadThisTime) {
            howMuchToReadThisTime = Math.toIntExact(Math.min(pending, (long)scratchPad.length));
            long pos = fc.pos();
            this.fileAsBuffer.get(pos, scratchPad, 0, howMuchToReadThisTime);
            fc.pos(pos + (long)howMuchToReadThisTime);
            dst.put(scratchPad, 0, howMuchToReadThisTime);
        }
        return Math.toIntExact(available);
    }

    synchronized int write(EphemeralPositionable fc, ByteBuffer src) {
        int wanted;
        int howMuchToWriteThisTime;
        byte[] scratchPad = new byte[(int)ByteUnit.kibiBytes((long)1L)];
        for (int pending = wanted = src.limit() - src.position(); pending > 0; pending -= howMuchToWriteThisTime) {
            howMuchToWriteThisTime = Math.min(pending, scratchPad.length);
            src.get(scratchPad, 0, howMuchToWriteThisTime);
            long pos = fc.pos();
            this.fileAsBuffer.put(pos, scratchPad, 0, howMuchToWriteThisTime);
            fc.pos(pos + (long)howMuchToWriteThisTime);
        }
        this.lastModified = this.clock.millis();
        return wanted;
    }

    synchronized EphemeralFileData copy() {
        return new EphemeralFileData(this.file, this.fileAsBuffer.copy(), this.clock);
    }

    synchronized void free() {
        this.fileAsBuffer.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(EphemeralFileChannel channel) {
        Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
        synchronized (collection) {
            this.channels.add(new WeakReference<EphemeralFileChannel>(channel));
        }
    }

    synchronized void force() {
        this.forcedBuffer = this.fileAsBuffer.copy();
    }

    synchronized void crash() {
        this.fileAsBuffer = this.forcedBuffer.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(EphemeralFileChannel channel) {
        Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
        synchronized (collection) {
            this.locked = 0;
            Iterator<WeakReference<EphemeralFileChannel>> iterator = this.channels.iterator();
            while (iterator.hasNext()) {
                WeakReference<EphemeralFileChannel> reference = iterator.next();
                EphemeralFileChannel openChannel = (EphemeralFileChannel)reference.get();
                if (openChannel != null && openChannel != channel) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<EphemeralFileChannel> getOpenChannels() {
        ArrayList<WeakReference<EphemeralFileChannel>> snapshot;
        Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
        synchronized (collection) {
            snapshot = new ArrayList<WeakReference<EphemeralFileChannel>>(this.channels);
        }
        final Iterator<WeakReference<EphemeralFileChannel>> refs = snapshot.iterator();
        return new PrefetchingIterator<EphemeralFileChannel>(){

            protected EphemeralFileChannel fetchNextOrNull() {
                while (refs.hasNext()) {
                    EphemeralFileChannel channel = (EphemeralFileChannel)((WeakReference)refs.next()).get();
                    if (channel != null) {
                        return channel;
                    }
                    refs.remove();
                }
                return null;
            }

            public void remove() {
                refs.remove();
            }
        };
    }

    synchronized long size() {
        return this.fileAsBuffer.getSize();
    }

    synchronized void truncate(long newSize) {
        this.fileAsBuffer.truncate(newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean takeLock() {
        Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
        synchronized (collection) {
            if (this.locked != 0) {
                return false;
            }
            ++this.locked;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock() {
        Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
        synchronized (collection) {
            if (this.locked != 0) {
                --this.locked;
            }
        }
    }

    public String toString() {
        return "EphemeralFileData[size: " + this.fileAsBuffer.getSize() + "]";
    }

    synchronized long getLastModified() {
        return this.lastModified;
    }
}

