/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.FileWatcher;

public class DelegatingFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;

    public DelegatingFileSystemAbstraction(FileSystemAbstraction delegate) {
        this.delegate = delegate;
    }

    public FileWatcher fileWatcher() throws IOException {
        return this.delegate.fileWatcher();
    }

    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        return this.delegate.open(fileName, options);
    }

    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        this.delegate.moveToDirectory(file, toDirectory);
    }

    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        this.delegate.copyToDirectory(file, toDirectory);
    }

    public boolean mkdir(Path fileName) {
        return this.delegate.mkdir(fileName);
    }

    public void copyFile(Path from, Path to) throws IOException {
        this.delegate.copyFile(from, to);
    }

    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.delegate.copyFile(from, to, copyOptions);
    }

    public void truncate(Path path, long size) throws IOException {
        this.delegate.truncate(path, size);
    }

    public long lastModifiedTime(Path file) {
        return this.delegate.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(Path file) throws IOException {
        this.delegate.deleteFileOrThrow(file);
    }

    public Stream<FileHandle> streamFilesRecursive(Path directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive((Path)directory, (FileSystemAbstraction)this);
    }

    public int getFileDescriptor(StoreChannel channel) {
        return this.delegate.getFileDescriptor(channel);
    }

    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.delegate.renameFile(from, to, copyOptions);
    }

    public StoreChannel read(Path fileName) throws IOException {
        return this.delegate.read(fileName);
    }

    public StoreChannel write(Path fileName) throws IOException {
        return this.delegate.write(fileName);
    }

    public void mkdirs(Path fileName) throws IOException {
        this.delegate.mkdirs(fileName);
    }

    public boolean deleteFile(Path fileName) {
        return this.delegate.deleteFile(fileName);
    }

    public InputStream openAsInputStream(Path fileName) throws IOException {
        return this.delegate.openAsInputStream(fileName);
    }

    public boolean fileExists(Path file) {
        return this.delegate.fileExists(file);
    }

    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) {
        return this.delegate.listFiles(directory, filter);
    }

    public boolean isDirectory(Path file) {
        return this.delegate.isDirectory(file);
    }

    public long getFileSize(Path fileName) {
        return this.delegate.getFileSize(fileName);
    }

    public long getBlockSize(Path file) throws IOException {
        return this.delegate.getBlockSize(file);
    }

    public Writer openAsWriter(Path fileName, Charset charset, boolean append) throws IOException {
        return this.delegate.openAsWriter(fileName, charset, append);
    }

    public Path[] listFiles(Path directory) {
        return this.delegate.listFiles(directory);
    }

    public void deleteRecursively(Path directory) throws IOException {
        this.delegate.deleteRecursively(directory);
    }

    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        return this.delegate.openAsOutputStream(fileName, append);
    }

    public Reader openAsReader(Path fileName, Charset charset) throws IOException {
        return this.delegate.openAsReader(fileName, charset);
    }

    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

