/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;

public class ChannelInputStream
extends InputStream {
    private final StoreChannel channel;
    private final ScopedBuffer scopedBuffer;
    private final ByteBuffer buffer;
    private int position;

    public ChannelInputStream(StoreChannel channel, MemoryTracker memoryTracker) {
        this.channel = channel;
        this.scopedBuffer = new HeapScopedBuffer(8, ByteUnit.KibiByte, memoryTracker);
        this.buffer = this.scopedBuffer.getBuffer();
    }

    @Override
    public int read() throws IOException {
        this.buffer.clear();
        this.buffer.limit(1);
        while (this.buffer.hasRemaining()) {
            int read = this.channel.read(this.buffer);
            if (read != -1) continue;
            return -1;
        }
        this.buffer.flip();
        ++this.position;
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return (int)((long)this.position - this.channel.size());
    }

    @Override
    public void close() throws IOException {
        this.scopedBuffer.close();
        this.channel.close();
    }
}

