/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.pagecache;

import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.test.extension.FileSystemExtension;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.rule.PageCacheConfig;
import org.neo4j.test.rule.PageCacheRule;

public class PageCacheSupportExtension
extends StatefullFieldExtension<PageCache> {
    private static final String PAGE_CACHE = "pageCache";
    private static final ExtensionContext.Namespace PAGE_CACHE_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"pageCache"});
    private final PageCacheConfig config;

    public PageCacheSupportExtension() {
        this(PageCacheConfig.config());
    }

    public PageCacheSupportExtension(PageCacheConfig config) {
        this.config = config;
    }

    protected String getFieldKey() {
        return PAGE_CACHE;
    }

    protected Class<PageCache> getFieldType() {
        return PageCache.class;
    }

    protected PageCache createField(ExtensionContext extensionContext) {
        ExtensionContext.Store fileSystemStore = PageCacheSupportExtension.getStore((ExtensionContext)extensionContext, (ExtensionContext.Namespace)FileSystemExtension.FILE_SYSTEM_NAMESPACE);
        FileSystemAbstraction contextFileSystem = (FileSystemAbstraction)fileSystemStore.get((Object)"fileSystem", FileSystemAbstraction.class);
        FileSystemAbstraction pageCacheFileSystem = Optional.ofNullable(contextFileSystem).orElseGet(DefaultFileSystemAbstraction::new);
        return new PageCacheRule().getPageCache(pageCacheFileSystem, this.config);
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheConfig config) {
        return new PageCacheRule().getPageCache(fs, config);
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        return new PageCacheRule().getPageCache(fs, PageCacheConfig.config());
    }

    public PageCache getPageCache(PageSwapperFactory factory) {
        return new PageCacheRule().getPageCache(factory, PageCacheConfig.config());
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return PAGE_CACHE_NAMESPACE;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        PageCache storedValue = (PageCache)this.getStoredValue(context);
        if (storedValue != null) {
            storedValue.close();
        }
        super.afterAll(context);
    }
}

