/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.PageCacheStresser;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

public class PageCacheStressTest {
    private final int numberOfPages;
    private final int numberOfThreads;
    private final int numberOfCachePages;
    private final PageCacheTracer tracer;
    private final Condition condition;
    private final Path workingDirectory;
    private final ImmutableSet<OpenOption> openOptions;
    private final boolean asyncIO;

    private PageCacheStressTest(Builder builder) {
        this.numberOfPages = builder.numberOfPages;
        this.numberOfThreads = builder.numberOfThreads;
        this.numberOfCachePages = builder.numberOfCachePages;
        this.tracer = builder.tracer;
        this.condition = builder.condition;
        this.workingDirectory = builder.workingDirectory;
        this.openOptions = builder.openOptions;
        this.asyncIO = builder.asyncIO;
    }

    public void run() throws Exception {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             MuninnPageCache pageCacheUnderTest = new MuninnPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler, MuninnPageCache.config((int)this.numberOfCachePages).pageCacheTracer(this.tracer).withAsyncIO(this.asyncIO));){
            PageCacheStresser pageCacheStresser = new PageCacheStresser(this.numberOfPages, this.numberOfThreads, this.workingDirectory, this.openOptions);
            pageCacheStresser.stress((PageCache)pageCacheUnderTest, this.tracer, this.condition);
        }
    }

    public static class Builder {
        int numberOfPages = 10000;
        int numberOfThreads = 7;
        int numberOfCachePages = 1000;
        PageCacheTracer tracer = PageCacheTracer.NULL;
        Condition condition;
        Path workingDirectory;
        ImmutableSet<OpenOption> openOptions = Sets.immutable.empty();
        boolean asyncIO;

        public PageCacheStressTest build() {
            ((AbstractIntegerAssert)Assertions.assertThat((int)this.numberOfPages).describedAs("the cache should cover only a fraction of the mapped file", new Object[0])).isGreaterThanOrEqualTo(10 * this.numberOfCachePages);
            return new PageCacheStressTest(this);
        }

        public Builder with(PageCacheTracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder with(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder withNumberOfPages(int value) {
            this.numberOfPages = value;
            return this;
        }

        public Builder withNumberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public Builder withNumberOfCachePages(int numberOfCachePages) {
            this.numberOfCachePages = numberOfCachePages;
            return this;
        }

        public Builder withWorkingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder withAsyncIO(boolean asyncOperations) {
            this.asyncIO = asyncOperations;
            return this;
        }

        public Builder with(ImmutableSet<OpenOption> openOptions) {
            this.openOptions = openOptions;
            return this;
        }
    }
}

