/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialReadPageCursor;
import org.neo4j.adversaries.pagecache.AdversarialWritePageCursor;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.DelegatingPagedFile;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.version.FileTruncateEvent;

public class AdversarialPagedFile
extends DelegatingPagedFile {
    private final Adversary adversary;

    public AdversarialPagedFile(PagedFile delegate, Adversary adversary) {
        super(delegate);
        Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    @Override
    public PageCursor io(long pageId, int pf_flags, CursorContext context) throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        PageCursor pageCursor = this.delegate.io(pageId, pf_flags, context);
        if ((pf_flags & 1) == 1) {
            return new AdversarialReadPageCursor(pageCursor, this.adversary);
        }
        return new AdversarialWritePageCursor(pageCursor, this.adversary);
    }

    @Override
    public long fileSize() throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        return this.delegate.fileSize();
    }

    @Override
    public void flushAndForce(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce(flushEvent, asyncBlockAccessor);
    }

    @Override
    public long getLastPageId() throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        return this.delegate.getLastPageId();
    }

    @Override
    public void close() {
        this.adversary.injectFailure(NoSuchFileException.class, SecurityException.class);
        this.delegate.close();
    }

    @Override
    public void truncate(long pagesToKeep, FileTruncateEvent fileTruncateEvent) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.truncate(pagesToKeep, fileTruncateEvent);
    }

    @Override
    public int touch(long pageId, int count, CursorContext cursorContext) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.touch(pageId, count, cursorContext);
    }

    public String toString() {
        return "AdversarialPagedFile{delegate=" + String.valueOf(this.delegate) + "}";
    }
}

