/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;

public class BufferBackedChannel
implements WritableChannel,
ReadableChannel {
    private final ByteBuffer buffer;
    private boolean isClosed;

    public BufferBackedChannel(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public BufferBackedChannel(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte get() {
        return this.buffer.get();
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public void get(byte[] bytes, int length) {
        this.buffer.get(bytes, 0, length);
    }

    public byte getVersion() throws IOException {
        return this.buffer.get();
    }

    public long getAppendIndex() throws IOException {
        return this.getLong();
    }

    public int read(ByteBuffer dst) {
        int remaining = this.buffer.remaining();
        if (remaining >= dst.remaining()) {
            ByteBuffer subBuffer = this.buffer.slice().limit(dst.remaining());
            int subRemaining = subBuffer.remaining();
            dst.put(subBuffer);
            this.buffer.position(this.buffer.position() + subRemaining);
            return subRemaining;
        }
        dst.put(this.buffer);
        return remaining;
    }

    public BufferBackedChannel put(byte value) {
        this.buffer.put(value);
        return this;
    }

    public BufferBackedChannel putShort(short value) {
        this.buffer.putShort(value);
        return this;
    }

    public BufferBackedChannel putInt(int value) {
        this.buffer.putInt(value);
        return this;
    }

    public BufferBackedChannel putLong(long value) {
        this.buffer.putLong(value);
        return this;
    }

    public BufferBackedChannel putFloat(float value) {
        this.buffer.putFloat(value);
        return this;
    }

    public BufferBackedChannel putDouble(double value) {
        this.buffer.putDouble(value);
        return this;
    }

    public BufferBackedChannel put(byte[] value, int offset, int length) {
        this.buffer.put(value, offset, length);
        return this;
    }

    public BufferBackedChannel putAll(ByteBuffer src) throws IOException {
        this.buffer.put(src);
        return this;
    }

    public BufferBackedChannel putVersion(byte version) {
        return this.put(version);
    }

    public WritableChannel putAppendIndex(long appendIndex) {
        return this.putLong(appendIndex);
    }

    public int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        this.buffer.put(src);
        return remaining;
    }

    public boolean isOpen() {
        return !this.isClosed;
    }

    public void beginChecksumForWriting() {
    }

    public int putChecksum() throws IOException {
        return 0;
    }

    public void beginChecksum() {
    }

    public int getChecksum() {
        return 0;
    }

    public int endChecksumAndValidate() {
        return 0;
    }

    public long position() {
        return this.buffer.position();
    }

    public void position(long byteOffset) throws IOException {
        this.buffer.position(Math.toIntExact(byteOffset));
    }

    public void close() {
        this.isClosed = true;
    }

    public char getChar() {
        return this.buffer.getChar();
    }

    public BufferBackedChannel flip() {
        this.buffer.flip();
        return this;
    }
}

