/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.testdirectory;

import java.io.IOException;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.DynamicTestInvocationContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.JUnitException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.FileSystemExtension;
import org.neo4j.test.extension.StatefulFieldExtension;
import org.neo4j.test.utils.TestDirectory;
import org.opentest4j.TestAbortedException;

public class TestDirectorySupportExtension
extends StatefulFieldExtension<TestDirectory>
implements BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback,
TestExecutionExceptionHandler,
InvocationInterceptor {
    public static final String TEST_DIRECTORY = "testDirectory";
    public static final String FAILURE_MARKER = "failureMarker";
    public static final String DYNAMIC_TEST_FAILURE_MARKER = "dynamicTestFailureMarker";
    public static final ExtensionContext.Namespace TEST_DIRECTORY_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"testDirectory"});
    private static final String JUNIT4_ASSUMPTION_EXCEPTION = "org.junit.AssumptionViolatedException";

    public static TestDirectory getTestDirectory(ExtensionContext context) {
        return (TestDirectory)context.getStore(TEST_DIRECTORY_NAMESPACE).get((Object)TEST_DIRECTORY);
    }

    public void beforeAll(ExtensionContext context) throws IOException {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            this.prepare(context);
        }
    }

    public void beforeEach(ExtensionContext context) throws IOException {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            this.prepare(context);
        }
    }

    public void afterEach(ExtensionContext context) {
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            this.cleanUp(context);
        }
    }

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> inv, DynamicTestInvocationContext invContext, ExtensionContext context) throws Throwable {
        try {
            super.interceptDynamicTest(inv, invContext, context);
        }
        catch (Throwable throwable) {
            try {
                if (!TestDirectorySupportExtension.isTestAssumptionCheckFailure(throwable)) {
                    this.getTestDirectoryStore((ExtensionContext)context.getParent().orElseThrow()).put((Object)DYNAMIC_TEST_FAILURE_MARKER, (Object)Boolean.TRUE);
                }
            }
            catch (RuntimeException e) {
                throwable.addSuppressed(e);
            }
            throw throwable;
        }
    }

    public void afterAll(ExtensionContext context) throws IOException {
        TestDirectory directory;
        if (TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            this.cleanUp(context);
        }
        if ((directory = (TestDirectory)this.getStoredValue(context)) != null) {
            directory.close();
        }
    }

    private static TestInstance.Lifecycle getLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
    }

    public void prepare(ExtensionContext context) throws IOException {
        String name = context.getTestMethod().map(method -> method.getName().concat(context.getDisplayName())).orElseGet(() -> context.getRequiredTestClass().getSimpleName());
        TestDirectory testDirectory = (TestDirectory)this.getStoredValue(context);
        testDirectory.prepareDirectory(context.getRequiredTestClass(), name);
    }

    private void cleanUp(ExtensionContext context) {
        TestDirectory testDirectory = (TestDirectory)this.getStoredValue(context);
        try {
            testDirectory.complete((context.getExecutionException().isEmpty() || TestDirectorySupportExtension.isTestAssumptionCheckFailure((Throwable)context.getExecutionException().get())) && !this.hasFailureMarker(context));
        }
        catch (Exception e) {
            throw new JUnitException(String.format("Fail to cleanup test directory for %s test.", context.getDisplayName()), (Throwable)e);
        }
    }

    protected String getFieldKey() {
        return TEST_DIRECTORY;
    }

    protected Class<TestDirectory> getFieldType() {
        return TestDirectory.class;
    }

    protected TestDirectory createField(ExtensionContext extensionContext) {
        ExtensionContext.Store fileSystemStore = TestDirectorySupportExtension.getStore((ExtensionContext)extensionContext, (ExtensionContext.Namespace)FileSystemExtension.FILE_SYSTEM_NAMESPACE);
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)fileSystemStore.get((Object)"fileSystem", FileSystemAbstraction.class);
        return fileSystemAbstraction != null ? TestDirectory.testDirectory(fileSystemAbstraction) : TestDirectory.testDirectory();
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return TEST_DIRECTORY_NAMESPACE;
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (!TestDirectorySupportExtension.isTestAssumptionCheckFailure(throwable) && TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            ExtensionContext.Store store = this.getTestDirectoryStore(context);
            store.put((Object)FAILURE_MARKER, (Object)Boolean.TRUE);
        }
        throw throwable;
    }

    private static boolean isTestAssumptionCheckFailure(Throwable throwable) {
        if (throwable instanceof TestAbortedException) {
            return true;
        }
        return throwable.getClass().getCanonicalName().equals(JUNIT4_ASSUMPTION_EXCEPTION);
    }

    private boolean hasFailureMarker(ExtensionContext context) {
        ExtensionContext.Store store = this.getLocalStore(context);
        return TestDirectorySupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS && store.get((Object)FAILURE_MARKER) != null || store.get((Object)DYNAMIC_TEST_FAILURE_MARKER) != null;
    }

    private ExtensionContext.Store getTestDirectoryStore(ExtensionContext context) {
        ExtensionContext.Store store = null;
        while (context != null) {
            ExtensionContext.Store localStore = context.getStore(this.getNameSpace());
            if (localStore.get((Object)this.getFieldKey()) == null) {
                return store;
            }
            store = localStore;
            context = context.getParent().orElse(null);
        }
        throw new IllegalStateException("Test directory store not found");
    }
}

