/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.function.Supplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileData;
import org.neo4j.io.fs.EphemeralFileLock;
import org.neo4j.io.fs.EphemeralFileStillOpenException;
import org.neo4j.io.fs.EphemeralLocalPosition;
import org.neo4j.io.fs.EphemeralPositionable;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;

class EphemeralFileChannel
extends FileChannel
implements EphemeralPositionable {
    private static final boolean TRACE_FILE_OPEN = FeatureToggles.flag(EphemeralFileChannel.class, (String)"TRACE_FILE_OPEN", (boolean)false);
    private static final EphemeralFileStillOpenException PLACEHOLDER_EXCEPTION = new EphemeralFileStillOpenException("Enable " + EphemeralFileChannel.class.getName() + ".TRACE_FILE_OPEN flag to see actual stacktrace");
    final EphemeralFileStillOpenException openedAt;
    private final EphemeralFileData data;
    private long position;

    EphemeralFileChannel(EphemeralFileData data, Supplier<EphemeralFileStillOpenException> opened) {
        this.data = data;
        this.openedAt = TRACE_FILE_OPEN ? opened.get() : PLACEHOLDER_EXCEPTION;
        data.open(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.openedAt.getFilename() + "]";
    }

    private void checkIfClosedOrInterruptedOrMapped() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new ClosedByInterruptException();
        }
        if (this.data.isMapped()) {
            throw new UnsupportedOperationException("Proper support from mapped files are not implemented. Right now we only support mapping a file ONCE, then any further interactions with it will fail.");
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        return this.data.read(this, dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        return this.data.write(this, src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        return this.position;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        return this.data.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        this.data.truncate(size);
        this.pos(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        this.data.force();
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        long previousPos = this.position();
        this.position(position);
        try {
            long transferred;
            int read;
            ByteBuffer intermediary = ByteBuffers.allocate((int)Math.toIntExact(ByteUnit.MebiByte.toBytes(8L)), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            for (transferred = 0L; transferred < count; transferred += (long)read) {
                intermediary.clear();
                intermediary.limit((int)Math.min((long)intermediary.capacity(), count - transferred));
                read = src.read(intermediary);
                if (read == -1) break;
                intermediary.flip();
            }
            long l = transferred;
            return l;
        }
        finally {
            this.position(previousPos);
        }
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        return this.data.read(new EphemeralLocalPosition(position), dst);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        return this.data.write(new EphemeralLocalPosition(position), src);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        this.data.setIsMapped();
        return (MappedByteBuffer)ByteBuffer.allocateDirect(Math.toIntExact(size));
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        this.checkIfClosedOrInterruptedOrMapped();
        if (this.data.takeLock()) {
            return new EphemeralFileLock(this, this.data);
        }
        return null;
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) {
        if (this.data.takeLock()) {
            return new EphemeralFileLock(this, this.data);
        }
        throw new OverlappingFileLockException();
    }

    @Override
    protected void implCloseChannel() {
        this.data.close(this);
    }

    @Override
    public long pos() {
        return this.position;
    }

    @Override
    public void pos(long position) {
        this.position = position;
    }
}

