/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.utils;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ObjectUtils;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.checking.AccessCheckingPageCache;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.PageCacheConfig;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class PageCacheSupport {
    protected JobScheduler jobScheduler;
    protected SystemNanoClock clock;
    protected PageCache pageCache;
    private final PageCacheConfig baseConfig;

    public PageCacheSupport() {
        this(PageCacheConfig.config());
    }

    public PageCacheSupport(PageCacheConfig config) {
        this.baseConfig = config;
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        return this.getPageCache(fs, PageCacheConfig.config(), new Random());
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheConfig overriddenConfig) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fs, (PageCacheTracer)new DefaultPageCacheTracer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return this.getPageCache((PageSwapperFactory)factory, overriddenConfig, new Random());
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheConfig overriddenConfig, Random random) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fs, (PageCacheTracer)new DefaultPageCacheTracer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return this.getPageCache((PageSwapperFactory)factory, overriddenConfig, random);
    }

    public PageCache getPageCache(PageSwapperFactory swapperFactory) {
        return this.getPageCache(swapperFactory, PageCacheConfig.config(), new Random());
    }

    public PageCache getPageCache(PageSwapperFactory factory, PageCacheConfig overriddenConfig, Random random) {
        this.closeExistingPageCache();
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        MemoryAllocator mman = MemoryAllocator.createAllocator((long)ByteUnit.parse((String)PageCacheSupport.selectConfig(this.baseConfig.memory, overriddenConfig.memory, "8 MiB")), (MemoryTracker)memoryTracker);
        if (this.clock == null) {
            this.clock = Clocks.nanoClock();
        }
        MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)mman).memoryTracker((MemoryTracker)memoryTracker).clock(this.clock);
        Integer pageSize = PageCacheSupport.selectConfig(this.baseConfig.pageSize, overriddenConfig.pageSize, null);
        configuration = pageSize != null ? configuration.pageSize(pageSize.intValue()) : configuration;
        PageCacheTracer cacheTracer = PageCacheSupport.selectConfig(this.baseConfig.tracer, overriddenConfig.tracer, PageCacheTracer.NULL);
        configuration = configuration.pageCacheTracer(cacheTracer);
        Integer reservedPageBytes = PageCacheSupport.selectConfig(this.baseConfig.reservedPageBytes, overriddenConfig.reservedPageBytes, null);
        configuration = reservedPageBytes != null ? configuration.reservedPageBytes(reservedPageBytes.intValue()) : configuration;
        this.initializeJobScheduler();
        this.pageCache = new MuninnPageCache(factory, this.jobScheduler, configuration);
        this.pageCachePostConstruct(overriddenConfig, random);
        return this.pageCache;
    }

    protected void initializeJobScheduler() {
        this.jobScheduler = new ThreadPoolJobScheduler("PageCacheRule-");
    }

    protected static <T> T selectConfig(T base, T overridden, T defaultValue) {
        return (T)ObjectUtils.firstNonNull((Object[])new Object[]{base, overridden, defaultValue});
    }

    protected void pageCachePostConstruct(PageCacheConfig overriddenConfig, Random random) {
        if (PageCacheSupport.selectConfig(this.baseConfig.inconsistentReads, overriddenConfig.inconsistentReads, Boolean.TRUE).booleanValue()) {
            AtomicBoolean controller = PageCacheSupport.selectConfig(this.baseConfig.nextReadIsInconsistent, overriddenConfig.nextReadIsInconsistent, null);
            Adversary adversary = controller != null ? new AtomicBooleanInconsistentReadAdversary(controller, random) : new RandomInconsistentReadAdversary(random);
            this.pageCache = new AdversarialPageCache(this.pageCache, adversary);
        }
        if (PageCacheSupport.selectConfig(this.baseConfig.accessChecks, overriddenConfig.accessChecks, false).booleanValue()) {
            this.pageCache = new AccessCheckingPageCache(this.pageCache);
        }
    }

    protected void closeExistingPageCache() {
        this.closePageCache("Failed to stop existing PageCache prior to creating a new one.");
        this.closeJobScheduler("Failed to stop existing job scheduler prior to creating a new one.");
    }

    protected void after(boolean success) {
        this.closePageCache("Failed to stop PageCache after test.");
        this.closeJobScheduler("Failed to stop job scheduler after test.");
    }

    private void closeJobScheduler(String errorMessage) {
        if (this.jobScheduler != null) {
            try {
                this.jobScheduler.close();
            }
            catch (Exception e) {
                throw new RuntimeException(errorMessage, e);
            }
            this.jobScheduler = null;
        }
    }

    private void closePageCache(String errorMessage) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (Exception e) {
                throw new AssertionError(errorMessage, e);
            }
            this.pageCache = null;
        }
    }

    public static class AtomicBooleanInconsistentReadAdversary
    implements Adversary {
        final AtomicBoolean nextReadIsInconsistent;
        private final Random random;

        public AtomicBooleanInconsistentReadAdversary(AtomicBoolean nextReadIsInconsistent, Random random) {
            this.nextReadIsInconsistent = nextReadIsInconsistent;
            this.random = random;
        }

        @Override
        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @Override
        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return this.nextReadIsInconsistent.getAndSet(false);
        }

        @Override
        public Optional<Throwable> getLastAdversaryException() {
            return Optional.empty();
        }

        @Override
        public Random random() {
            return this.random;
        }
    }

    private static class RandomInconsistentReadAdversary
    implements Adversary {
        private final Random random;

        RandomInconsistentReadAdversary(Random random) {
            this.random = random;
        }

        @Override
        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @Override
        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return this.random.nextBoolean();
        }

        @Override
        public Optional<Throwable> getLastAdversaryException() {
            return Optional.empty();
        }

        @Override
        public Random random() {
            return this.random;
        }
    }
}

