/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import org.neo4j.internal.batchimport.GeneratingInputIterator;
import org.neo4j.internal.batchimport.RandomsStates;
import org.neo4j.internal.batchimport.input.DataGeneratorInput;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.csv.Deserialization;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Values;

public class RandomEntityDataGenerator
extends GeneratingInputIterator<RandomValues> {
    public RandomEntityDataGenerator(DataGeneratorInput.DataDistribution dataDistribution, long count, int batchSize, long seed, RandomValues.Configuration randomConfig, Header header) {
        super(count, batchSize, new RandomsStates(seed, randomConfig), (randoms, visitor, id) -> {
            block7: for (Header.Entry entry : header.entries()) {
                switch (entry.type()) {
                    case ID: {
                        if (dataDistribution.factorBadNodeData() > 0.0f && id > 0L && randoms.nextFloat() <= dataDistribution.factorBadNodeData()) {
                            id = randoms.nextLong(id);
                        }
                        Object idValue = RandomEntityDataGenerator.idValue(entry, id);
                        visitor.id(idValue, entry.group());
                        if (entry.name() == null) continue block7;
                        visitor.property(entry.name(), idValue, true);
                        continue block7;
                    }
                    case PROPERTY: {
                        Object value = dataDistribution.propertyValueGenerator().apply(entry, (RandomValues)randoms);
                        if (value == Values.NO_VALUE || value == null) continue block7;
                        visitor.property(entry.name(), value, false);
                        continue block7;
                    }
                    case LABEL: {
                        visitor.labels(dataDistribution.labelsGenerator().apply((RandomValues)randoms));
                        continue block7;
                    }
                    case START_ID: 
                    case END_ID: {
                        boolean connectedToDenseNode;
                        long nodeId = randoms.nextLong(dataDistribution.nodeCount() + dataDistribution.startNodeId());
                        boolean bl = connectedToDenseNode = dataDistribution.relationshipDistribution() < 1.0f && randoms.nextFloat() > dataDistribution.relationshipDistribution();
                        if (connectedToDenseNode) {
                            nodeId = (long)((float)((long)((float)nodeId * dataDistribution.relationshipDistribution())) / dataDistribution.relationshipDistribution());
                        }
                        if (dataDistribution.factorBadRelationshipData() > 0.0f && nodeId > 0L && randoms.nextFloat() <= dataDistribution.factorBadRelationshipData()) {
                            if (randoms.nextBoolean()) continue block7;
                            nodeId = randoms.nextLong() & 0xFFFFFFFFFFFFFFL;
                        }
                        if (entry.type() == Type.START_ID) {
                            visitor.startId(RandomEntityDataGenerator.idValue(entry, nodeId), entry.group());
                            continue block7;
                        }
                        visitor.endId(RandomEntityDataGenerator.idValue(entry, nodeId), entry.group());
                        continue block7;
                    }
                    case TYPE: {
                        visitor.type(dataDistribution.relationshipTypeGenerator().apply((RandomValues)randoms));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException(entry.toString());
                    }
                }
            }
        }, dataDistribution.startNodeId());
    }

    private static Object idValue(Header.Entry entry, long id) {
        return switch (entry.extractor().name()) {
            case "String" -> Long.toString(id);
            case "long" -> id;
            default -> throw new IllegalArgumentException(entry.name());
        };
    }

    public static <T> T convert(InputEntity entity, Deserialization<T> deserialization, Header header) {
        deserialization.clear();
        block8: for (Header.Entry entry : header.entries()) {
            switch (entry.type()) {
                case ID: {
                    deserialization.handle(entry, entity.hasLongId ? Long.valueOf(entity.longId) : entity.objectId);
                    continue block8;
                }
                case PROPERTY: {
                    deserialization.handle(entry, entity.getProperty(entry.name()).value());
                    continue block8;
                }
                case LABEL: {
                    deserialization.handle(entry, (Object)entity.labels());
                    continue block8;
                }
                case TYPE: {
                    deserialization.handle(entry, entity.hasIntType ? Integer.valueOf(entity.intType) : entity.stringType);
                    continue block8;
                }
                case START_ID: {
                    deserialization.handle(entry, entity.hasLongStartId ? Long.valueOf(entity.longStartId) : entity.objectStartId);
                    continue block8;
                }
                case END_ID: {
                    deserialization.handle(entry, entity.hasLongEndId ? Long.valueOf(entity.longEndId) : entity.objectEndId);
                    continue block8;
                }
            }
        }
        return (T)deserialization.materialize();
    }
}

