/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.index.internal.gbptree.TestLayout;
import org.neo4j.io.pagecache.PageCursor;

public class SimpleLongLayout
extends TestLayout<MutableLong, MutableLong> {
    private final int keyPadding;
    private final boolean bitSetValue;

    public static Builder longLayout() {
        return new Builder();
    }

    private SimpleLongLayout(int keyPadding, boolean fixedSize, int identifier, int majorVersion, int minorVersion, boolean bitSetValue) {
        super(fixedSize, identifier, majorVersion, minorVersion);
        this.keyPadding = keyPadding;
        this.bitSetValue = bitSetValue;
    }

    public int compare(MutableLong o1, MutableLong o2) {
        return Long.compare(o1.longValue(), o2.longValue());
    }

    @Override
    int compareValue(MutableLong v1, MutableLong v2) {
        return this.compare(v1, v2);
    }

    public MutableLong newKey() {
        return new MutableLong();
    }

    public MutableLong copyKey(MutableLong key, MutableLong into) {
        into.setValue(key.longValue());
        return into;
    }

    public MutableLong newValue() {
        return new MutableLong();
    }

    public int keySize(MutableLong key) {
        return 8 + this.keyPadding;
    }

    public int valueSize(MutableLong value) {
        return 8;
    }

    public void writeKey(PageCursor cursor, MutableLong key) {
        cursor.putLong(key.longValue());
        cursor.putBytes(this.keyPadding, (byte)0);
    }

    public void writeValue(PageCursor cursor, MutableLong value) {
        cursor.putLong(value.longValue());
    }

    public void readKey(PageCursor cursor, MutableLong into, int keySize) {
        into.setValue(cursor.getLong());
        cursor.getBytes(new byte[this.keyPadding]);
    }

    public void readValue(PageCursor cursor, MutableLong into, int valueSize) {
        into.setValue(cursor.getLong());
    }

    @Override
    public MutableLong key(long seed) {
        MutableLong key = this.newKey();
        key.setValue(seed);
        return key;
    }

    @Override
    public MutableLong value(long seed) {
        MutableLong value = this.newValue();
        value.setValue(seed);
        return value;
    }

    @Override
    public long keySeed(MutableLong key) {
        return key.getValue();
    }

    @Override
    public long valueSeed(MutableLong value) {
        return value.getValue();
    }

    public void initializeAsLowest(MutableLong key) {
        key.setValue(Long.MIN_VALUE);
    }

    public void initializeAsHighest(MutableLong key) {
        key.setValue(Long.MAX_VALUE);
    }

    public boolean bitSetValue() {
        return this.bitSetValue;
    }

    public static class Builder {
        private int keyPadding;
        private int identifier = 999;
        private int majorVersion;
        private int minorVersion;
        private boolean fixedSize = true;
        private boolean bitSetValue = false;

        public Builder withKeyPadding(int keyPadding) {
            this.keyPadding = keyPadding;
            return this;
        }

        public Builder withIdentifier(int identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withMajorVersion(int majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public Builder withMinorVersion(int minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public Builder withFixedSize(boolean fixedSize) {
            this.fixedSize = fixedSize;
            return this;
        }

        public Builder bitSetValue(boolean bitSetValue) {
            this.bitSetValue = bitSetValue;
            return this;
        }

        public SimpleLongLayout build() {
            return new SimpleLongLayout(this.keyPadding, this.fixedSize, this.identifier, this.majorVersion, this.minorVersion, this.bitSetValue);
        }
    }
}

