/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GenerationKeeper;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;

public final class GBPTreeCorruption {
    private GBPTreeCorruption() {
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> crashed(GBPTreePointerType gbpTreePointerType) {
        return (pageCursor, layout, node, treeState) -> {
            int offset = gbpTreePointerType.offset(node);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            long crashGeneration = GBPTreeCorruption.crashGeneration(treeState);
            pageCursor.setOffset(offset);
            long pointer = GenerationSafePointerPair.pointer((long)GenerationSafePointerPair.read((PageCursor)pageCursor, (long)stableGeneration, (long)unstableGeneration, (GBPTreeGenerationTarget)GBPTreeGenerationTarget.NO_GENERATION_TARGET));
            GBPTreeCorruption.overwriteGSPP(pageCursor, offset, crashGeneration, pointer);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> broken(GBPTreePointerType gbpTreePointerType) {
        return (pageCursor, layout, node, treeState) -> {
            int offset = gbpTreePointerType.offset(node);
            pageCursor.setOffset(offset);
            pageCursor.putInt(Integer.MAX_VALUE);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setPointer(GBPTreePointerType pointerType, long pointer) {
        return (cursor, layout, node, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, pointerType.offset(node), treeState.stableGeneration(), pointer);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> notATreeNode() {
        return (cursor, layout, node, treeState) -> cursor.putByte(0, (byte)127);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> notAnOffloadNode() {
        return (cursor, layout, node, treeState) -> cursor.putByte(0, (byte)127);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> unknownTreeNodeType() {
        return (cursor, layout, node, treeState) -> cursor.putByte(1, (byte)127);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> rightSiblingPointToNonExisting() {
        return (cursor, layout, node, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.rightSibling().offset(node), treeState.stableGeneration(), 0xFFFFFFFFFFFFL);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> leftSiblingPointToNonExisting() {
        return (cursor, layout, node, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.leftSibling().offset(node), treeState.stableGeneration(), 0xFFFFFFFFFFFFL);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> rightSiblingPointerHasTooLowGeneration() {
        return (cursor, layout, node, treeState) -> {
            long rightSibling = GenerationSafePointerPair.pointer((long)TreeNode.rightSibling((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration()));
            GBPTreeCorruption.overwriteGSPP(cursor, 10, 1L, rightSibling);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> leftSiblingPointerHasTooLowGeneration() {
        return (cursor, layout, node, treeState) -> {
            long leftSibling = GenerationSafePointerPair.pointer((long)TreeNode.leftSibling((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration()));
            GBPTreeCorruption.overwriteGSPP(cursor, 34, 1L, leftSibling);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> childPointerHasTooLowGeneration(int childPos) {
        return (cursor, layout, node, treeState) -> {
            long child = GenerationSafePointerPair.pointer((long)node.childAt(cursor, childPos, treeState.stableGeneration(), treeState.unstableGeneration()));
            GBPTreeCorruption.overwriteGSPP(cursor, node.childOffset(childPos), 1L, child);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setChild(int childPos, long childPointer) {
        return (cursor, layout, node, treeState) -> {
            GenerationKeeper childGeneration = new GenerationKeeper();
            node.childAt(cursor, childPos, treeState.stableGeneration(), treeState.unstableGeneration(), (GBPTreeGenerationTarget)childGeneration);
            GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)childPos).offset(node), childGeneration.generation, childPointer);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> hasSuccessor() {
        return (cursor, layout, node, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, 58, treeState.unstableGeneration(), 0xFFFFFFFFFFFFL);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> swapKeyOrderLeaf(int firstKeyPos, int secondKeyPos, int keyCount) {
        return (cursor, layout, node, treeState) -> {
            int lowerKeyPos = Math.min(firstKeyPos, secondKeyPos);
            int higherKeyPos = firstKeyPos == lowerKeyPos ? secondKeyPos : firstKeyPos;
            Object key = layout.newKey();
            Object value = layout.newValue();
            node.keyAt(cursor, key, higherKeyPos, TreeNode.Type.LEAF, CursorContext.NULL_CONTEXT);
            node.valueAt(cursor, new TreeNode.ValueHolder(value), higherKeyPos, CursorContext.NULL_CONTEXT);
            int newCount = node.removeKeyValueAt(cursor, higherKeyPos, keyCount, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)newCount);
            node.defragmentLeaf(cursor);
            node.insertKeyValueAt(cursor, key, value, lowerKeyPos, newCount, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)keyCount);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> swapKeyOrderInternal(int firstKeyPos, int secondKeyPos, int keyCount) {
        return (cursor, layout, node, treeState) -> {
            int lowerKeyPos = firstKeyPos < secondKeyPos ? firstKeyPos : secondKeyPos;
            int higherKeyPos = firstKeyPos == lowerKeyPos ? secondKeyPos : firstKeyPos;
            Object key = layout.newKey();
            node.keyAt(cursor, key, higherKeyPos, TreeNode.Type.INTERNAL, CursorContext.NULL_CONTEXT);
            GenerationKeeper childPointerGeneration = new GenerationKeeper();
            long rightChild = node.childAt(cursor, higherKeyPos + 1, treeState.stableGeneration(), treeState.unstableGeneration(), (GBPTreeGenerationTarget)childPointerGeneration);
            node.removeKeyAndRightChildAt(cursor, higherKeyPos, keyCount, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)(keyCount - 1));
            node.defragmentInternal(cursor);
            node.insertKeyAndRightChildAt(cursor, key, rightChild, lowerKeyPos, keyCount - 1, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)keyCount);
            int childOffset = node.childOffset(lowerKeyPos + 1);
            GBPTreeCorruption.overwriteGSPP(cursor, childOffset, childPointerGeneration.generation, rightChild);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> swapChildOrder(int firstChildPos, int secondChildPos, int keyCount) {
        return (cursor, layout, node, treeState) -> {
            GenerationKeeper firstChildGeneration = new GenerationKeeper();
            long firstChild = node.childAt(cursor, firstChildPos, treeState.stableGeneration(), treeState.unstableGeneration(), (GBPTreeGenerationTarget)firstChildGeneration);
            GenerationKeeper secondChildGeneration = new GenerationKeeper();
            long secondChild = node.childAt(cursor, secondChildPos, treeState.stableGeneration(), treeState.unstableGeneration(), (GBPTreeGenerationTarget)secondChildGeneration);
            GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)firstChildPos).offset(node), secondChildGeneration.generation, secondChild);
            GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)secondChildPos).offset(node), firstChildGeneration.generation, firstChild);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> overwriteKeyAtPosLeaf(KEY key, int keyPos, int keyCount) {
        return (cursor, layout, node, treeState) -> {
            Object value = layout.newValue();
            node.valueAt(cursor, new TreeNode.ValueHolder(value), keyPos, CursorContext.NULL_CONTEXT);
            node.removeKeyValueAt(cursor, keyPos, keyCount, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)(keyCount - 1));
            node.defragmentLeaf(cursor);
            node.insertKeyValueAt(cursor, key, value, keyPos, keyCount - 1, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)keyCount);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> overwriteKeyAtPosInternal(KEY key, int keyPos, int keyCount) {
        return (cursor, layout, node, treeState) -> {
            long rightChild = node.childAt(cursor, keyPos + 1, treeState.stableGeneration(), treeState.unstableGeneration());
            node.removeKeyAndRightChildAt(cursor, keyPos, keyCount, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)(keyCount - 1));
            node.defragmentInternal(cursor);
            node.insertKeyAndRightChildAt(cursor, key, rightChild, keyPos, keyCount - 1, treeState.stableGeneration(), treeState.unstableGeneration(), CursorContext.NULL_CONTEXT);
            TreeNode.setKeyCount((PageCursor)cursor, (int)keyCount);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> maximizeAllocOffsetInDynamicNode() {
        return (cursor, layout, node, treeState) -> {
            TreeNodeDynamicSize dynamicNode = GBPTreeCorruption.assertDynamicNode(node);
            dynamicNode.setAllocOffset(cursor, cursor.getPagedFile().payloadSize());
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> minimizeAllocOffsetInDynamicNode() {
        return (cursor, layout, node, treeState) -> {
            TreeNodeDynamicSize dynamicNode = GBPTreeCorruption.assertDynamicNode(node);
            dynamicNode.setAllocOffset(cursor, dynamicNode.getHeaderLength());
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> decrementAllocOffsetInDynamicNode() {
        return (cursor, layout, node, treeState) -> {
            TreeNodeDynamicSize dynamicNode = GBPTreeCorruption.assertDynamicNode(node);
            int allocOffset = dynamicNode.getAllocOffset(cursor);
            dynamicNode.setAllocOffset(cursor, allocOffset - 1);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> incrementDeadSpaceInDynamicNode() {
        return (cursor, layout, node, treeState) -> {
            TreeNodeDynamicSize dynamicNode = GBPTreeCorruption.assertDynamicNode(node);
            int deadSpace = dynamicNode.getDeadSpace(cursor);
            dynamicNode.setDeadSpace(cursor, deadSpace + 1);
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> decrementFreelistWritePos() {
        return (pagedFile, layout, node, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                int decrementedWritePos = treeState.freeListWritePos() - 1;
                TreeState.write((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration(), (long)treeState.rootId(), (long)treeState.rootGeneration(), (long)treeState.lastId(), (long)treeState.freeListWritePageId(), (long)treeState.freeListReadPageId(), (int)decrementedWritePos, (int)treeState.freeListReadPos(), (boolean)treeState.isClean());
            }
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> addFreelistEntry(long releasedId) {
        return (pagedFile, layout, node, treeState) -> {
            FreeListIdProvider freelist = GBPTreeCorruption.getFreelist(pagedFile, treeState);
            CursorCreator cursorCreator = CursorCreator.bind((PagedFile)pagedFile, (int)2, (CursorContext)CursorContext.NULL_CONTEXT);
            freelist.releaseId(treeState.stableGeneration(), treeState.unstableGeneration(), releasedId, cursorCreator);
            freelist.flush(treeState.stableGeneration(), treeState.unstableGeneration(), cursorCreator);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                FreeListIdProvider.FreelistMetaData freelistMetaData = freelist.metaData();
                TreeState.write((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration(), (long)treeState.rootId(), (long)treeState.rootGeneration(), (long)freelistMetaData.lastId(), (long)freelistMetaData.writePageId(), (long)freelistMetaData.readPageId(), (int)freelistMetaData.writePos(), (int)freelistMetaData.readPos(), (boolean)treeState.isClean());
            }
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> setTreeState(TreeState target) {
        return (pagedFile, layout, node, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                TreeState.write((PageCursor)cursor, (long)target.stableGeneration(), (long)target.unstableGeneration(), (long)target.rootId(), (long)target.rootGeneration(), (long)target.lastId(), (long)target.freeListWritePageId(), (long)target.freeListReadPageId(), (int)target.freeListWritePos(), (int)target.freeListReadPos(), (boolean)target.isClean());
            }
        };
    }

    public static <VALUE, KEY> IndexCorruption<KEY, VALUE> copyChildPointerFromOther(long targetInternalNode, long otherInternalNode, int targetChildPos, int otherChildPos) {
        return (pagedFile, layout, node, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)otherInternalNode);
                GenerationKeeper generationKeeper = new GenerationKeeper();
                long child = node.childAt(cursor, otherChildPos, treeState.stableGeneration(), treeState.unstableGeneration(), (GBPTreeGenerationTarget)generationKeeper);
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)targetInternalNode);
                GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)targetChildPos).offset(node), generationKeeper.generation, child);
            }
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setKeyCount(int keyCount) {
        return (cursor, layout, node, treeState) -> cursor.putInt(6, keyCount);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setHighestReasonableKeyCount() {
        return (cursor, layout, node, treeState) -> {
            int keyCount = 0;
            while (node.reasonableKeyCount(keyCount + 1)) {
                ++keyCount;
            }
            cursor.putInt(6, keyCount);
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> pageSpecificCorruption(long targetPage, PageCorruption<KEY, VALUE> corruption) {
        return (pagedFile, layout, node, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)targetPage);
                corruption.corrupt(cursor, layout, node, treeState);
            }
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> makeDirty() {
        return (pagedFile, layout, node, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNode.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                TreeState.write((PageCursor)cursor, (long)(treeState.stableGeneration() + 1L), (long)(treeState.unstableGeneration() + 1L), (long)treeState.rootId(), (long)treeState.rootGeneration(), (long)treeState.lastId(), (long)treeState.freeListWritePageId(), (long)treeState.freeListReadPageId(), (int)treeState.freeListWritePos(), (int)treeState.freeListReadPos(), (boolean)false);
            }
        };
    }

    private static FreeListIdProvider getFreelist(PagedFile pagedFile, TreeState treeState) {
        FreeListIdProvider freelist = new FreeListIdProvider(pagedFile.payloadSize());
        freelist.initialize(treeState.lastId(), treeState.freeListWritePageId(), treeState.freeListReadPageId(), treeState.freeListWritePos(), 0);
        return freelist;
    }

    private static <KEY, VALUE> TreeNodeDynamicSize assertDynamicNode(TreeNode<KEY, VALUE> node) {
        if (!(node instanceof TreeNodeDynamicSize)) {
            throw new RuntimeException("Can not use this corruption if node is not of type " + TreeNodeDynamicSize.class.getSimpleName());
        }
        return (TreeNodeDynamicSize)node;
    }

    private static void overwriteGSPP(PageCursor cursor, int gsppOffset, long generation, long pointer) {
        cursor.setOffset(gsppOffset);
        GenerationSafePointer.write((PageCursor)cursor, (long)generation, (long)pointer);
        GenerationSafePointer.clean((PageCursor)cursor);
    }

    private static long crashGeneration(TreeState treeState) {
        if (treeState.unstableGeneration() - treeState.stableGeneration() < 2L) {
            throw new IllegalStateException("Need stable and unstable generation to have a crash gap but was stableGeneration=" + treeState.stableGeneration() + " and unstableGeneration=" + treeState.unstableGeneration());
        }
        return treeState.unstableGeneration() - 1L;
    }

    static interface PageCorruption<KEY, VALUE> {
        public void corrupt(PageCursor var1, Layout<KEY, VALUE> var2, TreeNode<KEY, VALUE> var3, TreeState var4) throws IOException;
    }

    static interface IndexCorruption<KEY, VALUE>
    extends GBPTreeUnsafe<KEY, VALUE> {
    }
}

