/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.io.pagecache.PageCursor;

public class SimpleIdProvider
implements IdProvider {
    private final Queue<Pair<Long, Long>> releasedIds = new LinkedList<Pair<Long, Long>>();
    private final Supplier<PageCursor> cursorSupplier;
    private long lastId;

    public SimpleIdProvider(Supplier<PageCursor> cursorSupplier) {
        this.cursorSupplier = cursorSupplier;
        this.reset();
    }

    public long acquireNewId(long stableGeneration, long unstableGeneration, CursorCreator cursorCreator) {
        Pair<Long, Long> free;
        if (!this.releasedIds.isEmpty() && (Long)(free = this.releasedIds.peek()).getLeft() <= stableGeneration) {
            this.releasedIds.poll();
            Long pageId = (Long)free.getRight();
            this.zapPage(pageId);
            return pageId;
        }
        ++this.lastId;
        return this.lastId;
    }

    public void releaseId(long stableGeneration, long unstableGeneration, long id, CursorCreator cursorCreator) {
        this.releasedIds.add((Pair<Long, Long>)Pair.of((Object)unstableGeneration, (Object)id));
    }

    LongIterator unacquiredIds() {
        LongHashSet unacquiredIds = new LongHashSet();
        this.releasedIds.forEach(arg_0 -> SimpleIdProvider.lambda$unacquiredIds$0((MutableLongSet)unacquiredIds, arg_0));
        return unacquiredIds.longIterator();
    }

    public void visitFreelist(IdProvider.IdProviderVisitor visitor, CursorCreator cursorCreator) {
        int pos = 0;
        visitor.beginFreelistPage(0L);
        for (Pair pair : this.releasedIds) {
            visitor.freelistEntry(((Long)pair.getRight()).longValue(), ((Long)pair.getLeft()).longValue(), pos++);
        }
        visitor.endFreelistPage(0L);
    }

    public long lastId() {
        return this.lastId;
    }

    void reset() {
        this.releasedIds.clear();
        this.lastId = 2L;
    }

    private void zapPage(Long pageId) {
        try (PageCursor cursor = this.cursorSupplier.get();){
            cursor.next(pageId.longValue());
            cursor.zapPage();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not go to page " + pageId);
        }
    }

    private static /* synthetic */ void lambda$unacquiredIds$0(MutableLongSet unacquiredIds, Pair pair) {
        unacquiredIds.add(((Long)pair.getValue()).longValue());
    }
}

